/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier;

import java.math.BigDecimal;
import org.openvpms.archetype.rules.act.ActStatusHelper;
import org.openvpms.archetype.rules.finance.tax.TaxRules;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.act.ActItemEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.system.ServiceHelper;

public abstract class SupplierActItemEditor
extends ActItemEditor {
    public SupplierActItemEditor(FinancialAct act, Act parent, LayoutContext context) {
        super((Act)act, parent, context);
        if (parent != null && !ActStatusHelper.isPosted((Act)parent, (ArchetypeService)ServiceHelper.getArchetypeService())) {
            this.calculateTax();
        }
        ModifiableListener listener = new ModifiableListener(){

            public void modified(Modifiable modifiable) {
                SupplierActItemEditor.this.updateTaxAmount();
            }
        };
        this.getProperty("quantity").addModifiableListener(listener);
        this.getProperty("unitPrice").addModifiableListener(listener);
    }

    protected void updateTaxAmount() {
        try {
            this.calculateTax();
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show((Throwable)exception);
        }
    }

    protected void calculateTax() {
        FinancialAct act = (FinancialAct)this.getObject();
        BigDecimal quantity = act.getQuantity();
        BigDecimal unitPrice = act.getUnitAmount();
        if (quantity != null && unitPrice != null) {
            Context context = this.getLayoutContext().getContext();
            Party practice = context.getPractice();
            Product product = (Product)this.getObject(this.getProductRef());
            if (product != null && practice != null) {
                BigDecimal amount = quantity.multiply(unitPrice);
                BigDecimal previousTax = act.getTaxAmount();
                TaxRules rules = new TaxRules(practice, (ArchetypeService)ServiceHelper.getArchetypeService());
                BigDecimal tax = rules.calculateTax(amount, product, false);
                if (tax.compareTo(previousTax) != 0) {
                    Property property = this.getProperty("tax");
                    property.setValue((Object)tax);
                }
            }
        }
    }
}

