/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier;

import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.ActCRUDWindow;
import org.openvpms.web.echo.help.HelpContext;

public abstract class SupplierActCRUDWindow<T extends Act>
extends ActCRUDWindow<T> {
    public SupplierActCRUDWindow(Archetypes<T> archetypes, ActActions<T> actions, Context context, HelpContext help) {
        super(archetypes, actions, context, help);
    }

    protected void onCreated(T act) {
        Party supplier = this.getContext().getSupplier();
        this.addParticipations(act, supplier, null);
        super.onCreated(act);
    }

    protected void addParticipations(T act, Party supplier, Party location) {
        try {
            IMObjectBean bean = this.getBean((IMObject)act);
            if (supplier != null) {
                bean.setTarget("supplier", (IMObject)supplier);
            }
            if (location != null) {
                bean.setTarget("stockLocation", (IMObject)location);
            }
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show((Throwable)exception);
        }
    }
}

