/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.select.IMObjectSelector;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.product.stock.StockLocationSelector;
import org.openvpms.web.workspace.supplier.SupplierSelector;

public class StockDetailsSelector {
    private final IMObjectSelector<Party> supplier;
    private final IMObjectSelector<Party> location;
    private final Component component;
    private final FocusGroup group;

    public StockDetailsSelector(LayoutContext context) {
        HelpContext help = context.getHelpContext();
        DefaultLayoutContext supplierContext = new DefaultLayoutContext(context, help.topic("supplier/select"));
        this.supplier = new SupplierSelector((LayoutContext)supplierContext, "party.supplierorganisation", "party.supplierperson");
        DefaultLayoutContext locationContext = new DefaultLayoutContext(context, help.topic("stockLocation/select"));
        this.location = new StockLocationSelector((LayoutContext)locationContext);
        Grid grid = GridFactory.create((int)2);
        grid.add((Component)LabelFactory.create((String)"supplier.type"));
        grid.add(this.supplier.getComponent());
        grid.add((Component)LabelFactory.create((String)"product.stockLocation"));
        grid.add(this.location.getComponent());
        this.component = grid;
        this.group = new FocusGroup("StockDetailsSelector");
        this.group.add(0, this.supplier.getFocusGroup());
        this.group.add(1, this.location.getFocusGroup());
        this.group.setFocus();
    }

    public Component getComponent() {
        return this.component;
    }

    public Party getSupplier() {
        return (Party)this.supplier.getObject();
    }

    public Party getStockLocation() {
        return (Party)this.location.getObject();
    }

    public FocusGroup getFocusGroup() {
        return this.group;
    }
}

