/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.till;

import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.ReadOnlyProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditor;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentLayoutStrategy;
import org.openvpms.web.workspace.customer.payment.PaymentStatus;
import org.openvpms.web.workspace.reporting.till.TillBalanceUpdater;

public class TillPaymentEditor
extends CustomerPaymentEditor {
    private final TillBalanceUpdater updater;

    public TillPaymentEditor(FinancialAct act, FinancialAct balance, LayoutContext context) {
        super(act, null, context);
        if (!act.isNew()) {
            throw new IllegalArgumentException("This cannot be used to edit persistent " + act.getArchetype());
        }
        this.setStatus("POSTED");
        this.updater = new TillBalanceUpdater(act, balance);
    }

    @Override
    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
        this.getParticipationEditor("customer", true).addModifiableListener(modifiable -> this.updateSummary());
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.updater.validate();
    }

    protected void doSave() {
        this.updater.prepare();
        super.doSave();
        this.updater.commit();
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new PaymentLayoutStrategy((IMObjectCollectionEditor)this.getItems(), this.getPaymentStatus());
    }

    private static class PaymentLayoutStrategy
    extends CustomerPaymentLayoutStrategy {
        public PaymentLayoutStrategy(IMObjectCollectionEditor editor, PaymentStatus status) {
            super(editor, status);
            this.getArchetypeNodes().simple(new String[]{"customer"}).order("customer", "till");
        }

        protected ComponentState createComponent(Property property, IMObject parent, LayoutContext context) {
            String name = property.getName();
            if ("status".equals(name) || "till".equals(name)) {
                return super.createComponent((Property)new ReadOnlyProperty(property), parent, context);
            }
            return super.createComponent(property, parent, context);
        }
    }
}

