/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.statement.reminder;

import java.util.Date;
import java.util.List;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.finance.reminder.AccountReminderRules;
import org.openvpms.component.business.service.scheduler.JobScheduler;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.processor.BatchProcessorDialog;
import org.openvpms.web.component.processor.ProgressBarProcessor;
import org.openvpms.web.component.workspace.AbstractViewCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.reporting.statement.reminder.AccountReminderProgressBarProcessor;
import org.openvpms.web.workspace.reporting.statement.reminder.AccountReminderQueryFactory;

public class AccountReminderCRUDWindow
extends AbstractViewCRUDWindow<Act> {
    private final AccountReminderRules rules = (AccountReminderRules)ServiceHelper.getBean(AccountReminderRules.class);
    private static final String SEND_ALL_ID = "button.sendAll";
    private static final String RESOLVE_ID = "button.resolve";
    private static final String RESOLVE_ALL_ID = "button.resolveAll";
    private static final String DISABLE_REMINDERS_ID = "button.disableReminders";
    private static final ReminderActions actions = new ReminderActions();

    public AccountReminderCRUDWindow(Context context, HelpContext help) {
        super(Archetypes.create((String)"act.customerChargeReminderSMS", Act.class), (IMObjectActions)actions, context, help);
    }

    public Act getCharge() {
        Act reminder = (Act)this.getObject();
        return reminder != null ? this.getCharge(reminder) : null;
    }

    protected void layoutButtons(ButtonSet buttons) {
        buttons.add(SEND_ALL_ID, this::onSendAll);
        buttons.add(RESOLVE_ID, this.action("act.customerChargeReminderSMS", this::onResolve, actions::canResolve, "reporting.statements.reminder.resolve.title"));
        buttons.add(RESOLVE_ALL_ID, this::onResolveAll);
        buttons.add(DISABLE_REMINDERS_ID, this.action(this::disableReminders, "customer.charge.disableReminders"));
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        Act object = (Act)this.getObject();
        buttons.setEnabled(RESOLVE_ID, enable && actions.canResolve(object));
        buttons.setEnabled(DISABLE_REMINDERS_ID, enable && this.canDisableReminders(object));
    }

    protected void view(Act object) {
        FinancialAct charge = object != null ? this.getCharge(object) : null;
        super.view((IMObject)charge);
    }

    protected FinancialAct getCharge(Act reminder) {
        return (FinancialAct)this.getBean((IMObject)reminder).getSource("charge", FinancialAct.class);
    }

    private void onSendAll() {
        JobScheduler scheduler = (JobScheduler)ServiceHelper.getBean(JobScheduler.class);
        List jobs = scheduler.getJobs("entity.jobAccountReminder");
        String title = Messages.get((String)"reporting.statements.reminder.send.title");
        if (!jobs.isEmpty()) {
            Entity job = (Entity)jobs.get(0);
            Date run = scheduler.getNextRunTime(job);
            String scheduled = run != null ? DateFormatter.formatDateTimeAbbrev((Date)run) : Messages.get((String)"admin.job.run.never");
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(title)).message(Messages.format((String)"reporting.statements.reminder.send.message", (Object[])new Object[]{job.getName(), scheduled}))).yesNo()).yes(() -> scheduler.run(job))).show();
        } else {
            InformationDialog.show((String)title, (String)Messages.format((String)"reporting.statements.reminder.send.nojob", (Object[])new Object[]{this.getDisplayName("entity.jobAccountReminder")}));
        }
    }

    private void onResolve(Act reminder) {
        this.rules.resolveError(reminder);
        this.onRefresh((IMObject)reminder);
    }

    private void onResolveAll() {
        ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.get((String)"reporting.statements.reminder.resolveall.prompt.title"))).message(Messages.get((String)"reporting.statements.reminder.resolveall.prompt.message"))).yesNo()).yes(this::onResolveAllConfirmed)).show();
    }

    private void onResolveAllConfirmed() {
        AccountReminderQueryFactory factory = new AccountReminderQueryFactory();
        factory.setStatuses(new String[]{"ERROR"});
        ResolveAllProgressBarProcessor processor = new ResolveAllProgressBarProcessor(factory);
        BatchProcessorDialog dialog = new BatchProcessorDialog(Messages.get((String)"reporting.statements.reminder.resolveall.run.title"), Messages.get((String)"reporting.statements.reminder.resolveall.run.message"), (ProgressBarProcessor)processor, true, this.getHelpContext());
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                AccountReminderCRUDWindow.this.onRefresh(AccountReminderCRUDWindow.this.getObject());
            }
        });
        dialog.show();
    }

    private void disableReminders(Act reminder) {
        FinancialAct charge = this.getCharge(reminder);
        if (charge != null) {
            this.rules.disableReminders(charge);
        }
        this.onRefresh((IMObject)reminder);
    }

    private boolean canDisableReminders(Act reminder) {
        FinancialAct charge;
        boolean result = false;
        if (reminder != null && (charge = this.getCharge(reminder)) != null) {
            result = this.rules.canDisableReminders(charge);
        }
        return result;
    }

    private static final class ReminderActions
    extends ActActions<Act> {
        private ReminderActions() {
        }

        public boolean canCreate() {
            return false;
        }

        public boolean canDelete(Act act) {
            return false;
        }

        public boolean canEdit(Act act) {
            return false;
        }

        public boolean canPost(Act act) {
            return false;
        }

        public boolean post(Act act) {
            return false;
        }

        public boolean canResolve(Act act) {
            return act != null && "ERROR".equals(act.getStatus());
        }
    }

    private class ResolveAllProgressBarProcessor
    extends AccountReminderProgressBarProcessor {
        public ResolveAllProgressBarProcessor(AccountReminderQueryFactory factory) {
            super(factory);
        }

        @Override
        protected void process(Act reminder, FinancialAct charge) {
            if (AccountReminderCRUDWindow.this.rules.resolveError(reminder)) {
                this.updated();
            }
        }
    }
}

