/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.statement;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.component.processor.Processor;
import org.openvpms.archetype.component.processor.ProcessorListener;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.statement.Statement;
import org.openvpms.archetype.rules.finance.statement.StatementProcessor;
import org.openvpms.archetype.rules.finance.statement.StatementProcessorException;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.mail.DefaultMailerFactory;
import org.openvpms.web.component.mail.EmailTemplateEvaluator;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.MailerFactory;
import org.openvpms.web.component.service.CurrentLocationMailService;
import org.openvpms.web.component.service.MailService;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.security.mail.MailPasswordResolver;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.communication.CommunicationHelper;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.statement.AbstractStatementGenerator;
import org.openvpms.web.workspace.reporting.statement.CustomerBalanceQuery;
import org.openvpms.web.workspace.reporting.statement.StatementEmailProcessor;
import org.openvpms.web.workspace.reporting.statement.StatementPrintProcessor;
import org.openvpms.web.workspace.reporting.statement.StatementProgressBarProcessor;

class StatementGenerator
extends AbstractStatementGenerator {
    private StatementProgressBarProcessor progressBarProcessor;
    private StatementProcessor processor;

    public StatementGenerator(IMObjectReference customer, Date date, boolean printOnly, Context context, MailContext mailContext, HelpContext help) {
        super(Messages.get((String)"reporting.statements.run.title"), Messages.get((String)"reporting.statements.run.cancel.title"), Messages.get((String)"reporting.statements.run.cancel.message"), Messages.get((String)"reporting.statements.run.retry.title"), help);
        ArrayList<Party> customers = new ArrayList<Party>();
        Party party = (Party)IMObjectHelper.getObject((Reference)customer, (Context)context);
        if (party != null) {
            customers.add(party);
        }
        this.init(customers, date, printOnly, context, mailContext, help);
    }

    public StatementGenerator(CustomerBalanceQuery query, Context context, MailContext mailContext, HelpContext help) {
        super(Messages.get((String)"reporting.statements.run.title"), Messages.get((String)"reporting.statements.run.cancel.title"), Messages.get((String)"reporting.statements.run.cancel.message"), Messages.get((String)"reporting.statements.run.retry.title"), help);
        List<ObjectSet> balances = query.getObjects();
        ArrayList<Party> customers = new ArrayList<Party>();
        for (ObjectSet set : balances) {
            IMObjectReference ref;
            Party customer;
            BigDecimal balance = set.getBigDecimal("balance");
            if (BigDecimal.ZERO.compareTo(balance) == 0 || (customer = (Party)IMObjectHelper.getObject((Reference)(ref = set.getReference("customer.objectReference")), (Context)context)) == null) continue;
            customers.add(customer);
        }
        this.init(customers, query.getDate(), false, context, mailContext, help);
    }

    public void setReprint(boolean reprint) {
        this.processor.setReprint(reprint);
    }

    @Override
    protected StatementProgressBarProcessor getProcessor() {
        return this.progressBarProcessor;
    }

    private void init(List<Party> customers, Date date, boolean printOnly, Context context, MailContext mailContext, HelpContext help) {
        Party practice = context.getPractice();
        if (practice == null) {
            throw new StatementProcessorException(StatementProcessorException.ErrorCode.InvalidConfiguration, new Object[]{"Context has no practice"});
        }
        IMPrinterFactory printerFactory = (IMPrinterFactory)ServiceHelper.getBean(IMPrinterFactory.class);
        ReporterFactory reporterFactory = (ReporterFactory)ServiceHelper.getBean(ReporterFactory.class);
        PracticeRules practiceRules = (PracticeRules)ServiceHelper.getBean(PracticeRules.class);
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        CustomerAccountRules customerAccountRules = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);
        MailPasswordResolver passwordResolver = (MailPasswordResolver)ServiceHelper.getBean(MailPasswordResolver.class);
        this.processor = new StatementProcessor(date, practice, (IArchetypeService)service, customerAccountRules);
        this.progressBarProcessor = new StatementProgressBarProcessor((Processor<Party>)this.processor, customers);
        CommunicationLogger logger = null;
        if (CommunicationHelper.isLoggingEnabled(practice, (IArchetypeService)service)) {
            logger = (CommunicationLogger)ServiceHelper.getBean(CommunicationLogger.class);
        }
        StatementPrintProcessor printer = new StatementPrintProcessor(this.progressBarProcessor, printerFactory, this.getCancelListener(), practice, context, mailContext, help, logger);
        if (printOnly) {
            this.processor.addListener((ProcessorListener)printer);
            printer.setUpdatePrinted(false);
        } else {
            MailerFactory mailerFactory = this.getMailerFactory();
            EmailTemplateEvaluator evaluator = (EmailTemplateEvaluator)ServiceHelper.getBean(EmailTemplateEvaluator.class);
            Party location = context.getLocation();
            if (location == null) {
                throw new StatementProcessorException(StatementProcessorException.ErrorCode.InvalidConfiguration, new Object[]{"Context has no location"});
            }
            StatementEmailProcessor mailer = new StatementEmailProcessor(mailerFactory, evaluator, reporterFactory, practice, location, practiceRules, (IArchetypeService)service, logger, passwordResolver);
            this.processor.addListener((ProcessorListener)new StatementDelegator(printer, mailer));
        }
    }

    private MailerFactory getMailerFactory() {
        return new DefaultMailerFactory((MailService)ServiceHelper.getBean(CurrentLocationMailService.class), (DocumentHandlers)ServiceHelper.getBean(DocumentHandlers.class));
    }

    private static class StatementDelegator
    implements ProcessorListener<Statement> {
        private final ProcessorListener<Statement> printer;
        private final ProcessorListener<Statement> mailer;

        StatementDelegator(ProcessorListener<Statement> printer, ProcessorListener<Statement> mailer) {
            this.printer = printer;
            this.mailer = mailer;
        }

        public void process(Statement statement) {
            Contact contact;
            ProcessorListener<Statement> listener = this.printer;
            List contacts = statement.getContacts();
            if (contacts.size() >= 1 && (contact = (Contact)contacts.get(0)).isA("contact.email")) {
                listener = this.mailer;
            }
            listener.process((Object)statement);
        }
    }
}

