/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.statement;

import java.util.Collection;
import java.util.Date;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.component.processor.BatchProcessorListener;
import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.im.print.ObjectSetReportPrinter;
import org.openvpms.web.component.im.print.PrinterContext;
import org.openvpms.web.component.im.print.PrinterContextFactory;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.AbstractCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.BillingCustomerMailContext;
import org.openvpms.web.workspace.customer.account.InteractiveStatementPrinter;
import org.openvpms.web.workspace.customer.account.StatementPrinter;
import org.openvpms.web.workspace.reporting.statement.CustomerBalanceBrowser;
import org.openvpms.web.workspace.reporting.statement.CustomerBalanceQuery;
import org.openvpms.web.workspace.reporting.statement.EndOfPeriodDialog;
import org.openvpms.web.workspace.reporting.statement.EndOfPeriodGenerator;
import org.openvpms.web.workspace.reporting.statement.SendStatementsDialog;
import org.openvpms.web.workspace.reporting.statement.StatementGenerator;

public class CustomerBalanceCRUDWindow
extends AbstractCRUDWindow<Act> {
    private final CustomerBalanceQuery query;
    private final CustomerBalanceBrowser browser;

    public CustomerBalanceCRUDWindow(CustomerBalanceQuery query, CustomerBalanceBrowser browser, Context context, HelpContext help) {
        super(Archetypes.create((Collection)CustomerAccountArchetypes.ACCOUNT_ACTS, Act.class), (IMObjectActions)ActActions.view(), context, help);
        this.query = query;
        this.browser = browser;
    }

    protected void layoutButtons(ButtonSet buttons) {
        UserRules rules = (UserRules)ServiceHelper.getBean(UserRules.class);
        boolean auth = rules.canEdit(this.getContext().getUser(), "act.customerAccountOpeningBalance");
        if (auth) {
            buttons.add("sendAll", this::onSendAll);
        }
        buttons.add("print", this::onPrint);
        buttons.add("report", this::onReport);
        if (auth) {
            buttons.add("endPeriod", this::onEndPeriod);
        }
    }

    protected void onPrint() {
        IMObjectReference ref;
        Party customer;
        ObjectSet selected = (ObjectSet)this.browser.getSelected();
        if (selected != null && (customer = (Party)IMObjectHelper.getObject((Reference)(ref = selected.getReference("customer.objectReference")), (Context)this.getContext())) != null) {
            HelpContext help = this.getHelpContext().subtopic("print");
            LocalContext context = LocalContext.copy((Context)this.getContext());
            context.setPatient(null);
            context.setCustomer(customer);
            BillingCustomerMailContext mailContext = new BillingCustomerMailContext((Context)context, help);
            PrinterContext printerContext = ((PrinterContextFactory)ServiceHelper.getBean(PrinterContextFactory.class)).create();
            StatementPrinter printer = new StatementPrinter((Context)context, (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class), printerContext, (ReporterFactory)ServiceHelper.getBean(ReporterFactory.class));
            InteractiveStatementPrinter interactive = new InteractiveStatementPrinter(printer, (Context)context, help);
            interactive.setMailContext((MailContext)mailContext);
            interactive.print();
        }
    }

    private void onSendAll() {
        if (this.checkStatementDate("reporting.statements.run.invalidDate")) {
            String title = Messages.get((String)"reporting.statements.run.title");
            String message = Messages.get((String)"reporting.statements.run.message");
            HelpContext help = this.getHelpContext().subtopic("confirmsend");
            final SendStatementsDialog dialog = new SendStatementsDialog(title, message, help);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    CustomerBalanceCRUDWindow.this.doSendAll(dialog.reprint());
                }
            });
            dialog.show();
        }
    }

    private void doSendAll(boolean reprint) {
        HelpContext help = this.getHelpContext().subtopic("send");
        StatementGenerator generator = new StatementGenerator(this.query, this.getContext(), this.getMailContext(), help);
        generator.setReprint(reprint);
        this.generateStatements(generator, true);
    }

    private void onEndPeriod() {
        if (this.checkStatementDate("reporting.statements.eop.invalidDate")) {
            String title = Messages.get((String)"reporting.statements.eop.title");
            String message = Messages.get((String)"reporting.statements.eop.message");
            final HelpContext help = this.getHelpContext().subtopic("endperiod");
            final EndOfPeriodDialog dialog = new EndOfPeriodDialog(title, message, help);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    CustomerBalanceCRUDWindow.this.doEndPeriod(dialog.postCompletedInvoices(), help);
                }
            });
            dialog.show();
        }
    }

    private void doEndPeriod(boolean postCompletedInvoices, HelpContext help) {
        Date date = DateRules.getDate((Date)this.query.getDate());
        EndOfPeriodGenerator generator = new EndOfPeriodGenerator(date, postCompletedInvoices, this.getContext(), help);
        generator.setListener(new BatchProcessorListener(){

            public void completed() {
                CustomerBalanceCRUDWindow.this.browser.query();
            }

            public void error(Throwable exception) {
                ErrorHelper.show((Throwable)exception);
            }
        });
        generator.process();
    }

    private void generateStatements(final StatementGenerator generator, final boolean refresh) {
        generator.setListener(new BatchProcessorListener(){

            public void completed() {
                if (refresh) {
                    CustomerBalanceCRUDWindow.this.browser.query();
                }
            }

            public void error(Throwable exception) {
                generator.getProcessor().setCancel(true);
                ErrorHelper.show((Throwable)exception);
            }
        });
        generator.process();
    }

    private boolean checkStatementDate(String errorKey) {
        Date statementDate = this.query.getDate();
        Date date = DateRules.getYesterday();
        if (date.compareTo(statementDate) < 0) {
            ErrorDialog.show((String)Messages.get((String)errorKey));
            return false;
        }
        return true;
    }

    private void onReport() {
        IMPrinterFactory factory = (IMPrinterFactory)ServiceHelper.getBean(IMPrinterFactory.class);
        Context context = this.getContext();
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator("CUSTOMER_BALANCE", context);
        ObjectSetReportPrinter printer = factory.createObjectSetReportPrinter(this.query.getObjects(), (DocumentTemplateLocator)locator, context);
        String type = this.query.queryAllBalances() ? Messages.get((String)"reporting.statements.print.all") : (this.query.queryOverduebalances() ? Messages.get((String)"reporting.statements.print.overdue") : Messages.get((String)"reporting.statements.print.nonOverdue"));
        String title = Messages.format((String)"imobject.print.title", (Object[])new Object[]{type});
        HelpContext help = this.getHelpContext().subtopic("report");
        InteractiveIMPrinter iPrinter = new InteractiveIMPrinter(title, (IMPrinter)printer, context, help);
        iPrinter.setMailContext(this.getMailContext());
        iPrinter.print();
    }
}

