/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.report;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.doc.AbstractDocumentTemplateQuery;
import org.openvpms.web.component.im.lookup.LookupField;
import org.openvpms.web.component.im.lookup.LookupFieldFactory;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.query.FilteredResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.system.ServiceHelper;

public class ReportQuery
extends AbstractDocumentTemplateQuery {
    private final Entity user;
    private String reportType;
    private LookupField typeSelector;
    private static final String TYPE_ID = "query.type";
    private static final SortConstraint[] DEFAULT_SORT = new SortConstraint[]{new NodeSortConstraint("name", true)};

    public ReportQuery(Entity user) {
        super(new String[]{"entity.documentTemplate"});
        this.user = user;
        this.setTemplateTypes(new String[]{"REPORT"});
        this.setAuto(true);
        this.setContains(true);
    }

    public boolean isAuto() {
        return this.user != null;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String type) {
        this.reportType = type;
    }

    protected ResultSet<Entity> createResultSet(SortConstraint[] sort) {
        int userReportLevel;
        ResultSet set = super.createResultSet(sort);
        if (this.user == null) {
            userReportLevel = 0;
        } else {
            IMObjectBean userBean = ServiceHelper.getArchetypeService().getBean((IMObject)this.user);
            userReportLevel = userBean.getInt("userLevel", 0);
        }
        return new FilteredResultSet<Entity>(set){

            protected void filter(Entity object, List<Entity> results) {
                IMObjectBean template = ServiceHelper.getArchetypeService().getBean((IMObject)object);
                int templateUserLevel = template.getInt("userLevel", 9);
                String reportType = template.getString("reportType");
                if (templateUserLevel <= userReportLevel && (ReportQuery.this.getReportType() == null || StringUtils.equals((CharSequence)ReportQuery.this.getReportType(), (CharSequence)reportType))) {
                    results.add(object);
                }
            }
        };
    }

    protected void doLayout(Component container) {
        this.addSearchField(container);
        FocusHelper.setFocus((Component)this.getSearchField());
        this.addReportTypeSelector(container);
    }

    protected void addReportTypeSelector(Component container) {
        NodeLookupQuery source = new NodeLookupQuery("entity.documentTemplate", "reportType");
        this.typeSelector = LookupFieldFactory.create((LookupQuery)source, (boolean)true);
        this.typeSelector.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                ReportQuery.this.onTypeChanged();
            }
        });
        this.typeSelector.setSelected((Lookup)null);
        Label typeLabel = LabelFactory.create((String)TYPE_ID);
        container.add((Component)typeLabel);
        container.add((Component)this.typeSelector);
        this.getFocusGroup().add((Component)this.typeSelector);
    }

    private void onTypeChanged() {
        this.setReportType(this.typeSelector.getSelectedCode());
    }
}

