/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.report;

import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Variables;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.component.business.service.archetype.helper.IMObjectVariables;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.report.ParameterType;

public class ParameterEvaluator {
    private final ArchetypeService service;
    private final LookupService lookups;
    private static final Log log = LogFactory.getLog(ParameterEvaluator.class);
    private static final String PREFIX = "$OpenVPMS.";

    public ParameterEvaluator(ArchetypeService service, LookupService lookups) {
        this.service = service;
        this.lookups = lookups;
    }

    public Set<ParameterType> evaluate(Set<ParameterType> parameterTypes, Map<String, Object> variables) {
        LinkedHashSet<ParameterType> result = new LinkedHashSet<ParameterType>();
        JXPathContext context = null;
        for (ParameterType type : parameterTypes) {
            ParameterType toAdd;
            if (this.canEvaluate(type)) {
                if (context == null) {
                    context = this.createContext(variables);
                }
                String value = this.evaluate(context, type.getName(), type.getDefaultValue().toString());
                toAdd = new ParameterType(type.getName(), type.getType(), type.getDescription(), (Object)value);
            } else {
                toAdd = type;
            }
            result.add(toAdd);
        }
        return result;
    }

    private boolean canEvaluate(ParameterType type) {
        boolean result = false;
        Object defaultValue = type.getDefaultValue();
        if (!type.isSystem() && defaultValue instanceof String && ((String)defaultValue).startsWith(PREFIX)) {
            if (String.class == type.getType()) {
                result = true;
            } else {
                log.error((Object)("Cannot evaluate parameter=" + type.getName() + ", type=" + type.getType() + ", defaultValue=" + type.getDefaultValue() + ": type must be a " + String.class.getName()));
            }
        }
        return result;
    }

    private String evaluate(JXPathContext context, String name, String expression) {
        String result = null;
        try {
            Object value = context.getValue(expression);
            if (value instanceof Date && !(value instanceof Timestamp)) {
                value = new Timestamp(((Date)value).getTime());
            }
            if (value != null) {
                result = value.toString();
            }
        }
        catch (Throwable exception) {
            log.warn((Object)("Failed to evaluate " + expression), exception);
        }
        return result;
    }

    private JXPathContext createContext(Map<String, Object> variables) {
        IMObjectVariables objectVariables = new IMObjectVariables(this.service, this.lookups);
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            objectVariables.add(entry.getKey(), entry.getValue());
        }
        JXPathContext context = JXPathHelper.newContext((Object)new Object());
        context.setVariables((Variables)objectVariables);
        return context;
    }
}

