/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workspace.AbstractCRUDWindow;
import org.openvpms.web.component.workspace.BrowserCRUDWindowTab;
import org.openvpms.web.component.workspace.TabComponent;
import org.openvpms.web.component.workspace.TabbedWorkspace;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.tabpane.ObjectTabPaneModel;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.CustomerPatientSummary;
import org.openvpms.web.workspace.patient.summary.CustomerPatientSummaryFactory;
import org.openvpms.web.workspace.reporting.reminder.ErrorReminderItemCRUDWindow;
import org.openvpms.web.workspace.reporting.reminder.PendingReminderItemBrowser;
import org.openvpms.web.workspace.reporting.reminder.PendingReminderItemCRUDWindow;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemBrowser;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemCRUDWindow;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemDateObjectSetQuery;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemDateRangeObjectSetQuery;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemQuery;
import org.openvpms.web.workspace.reporting.reminder.ResendReminderItemCRUDWindow;

public class ReminderWorkspace
extends TabbedWorkspace<Act> {
    private final Preferences preferences;

    public ReminderWorkspace(Context context, MailContext mailContext, Preferences preferences) {
        super("reporting.reminder", context);
        this.setMailContext(mailContext);
        this.preferences = preferences;
    }

    public Component getSummary() {
        Act reminder;
        Component result = null;
        Tab tab = (Tab)this.getSelected();
        Act act = reminder = tab != null ? tab.getWindow().getReminder() : null;
        if (reminder != null) {
            CustomerPatientSummaryFactory factory = (CustomerPatientSummaryFactory)ServiceHelper.getBean(CustomerPatientSummaryFactory.class);
            CustomerPatientSummary summary = factory.createCustomerPatientSummary(this.getContext(), this.getHelpContext(), this.preferences);
            result = summary.getSummary(reminder);
        }
        return result;
    }

    protected Class<Act> getType() {
        return Act.class;
    }

    protected void addTabs(ObjectTabPaneModel<TabComponent> model) {
        this.addSendBrowser(model);
        this.addErrorBrowser(model);
        this.addResendBrowser(model);
    }

    private void addSendBrowser(ObjectTabPaneModel<TabComponent> model) {
        HelpContext help = this.subtopic("send");
        DefaultLayoutContext context = new DefaultLayoutContext(this.getContext(), help);
        ReminderItemQuery query = new ReminderItemQuery(new ReminderItemDateObjectSetQuery("PENDING", context.getContext()));
        PendingReminderItemBrowser browser = new PendingReminderItemBrowser(query, (LayoutContext)context);
        PendingReminderItemCRUDWindow window = new PendingReminderItemCRUDWindow(browser, context.getContext(), context.getHelpContext());
        this.addTab("reporting.reminder.send", model, (TabComponent)new Tab((Browser<Act>)browser, window));
    }

    private void addErrorBrowser(ObjectTabPaneModel<TabComponent> model) {
        HelpContext help = this.subtopic("error");
        DefaultLayoutContext context = new DefaultLayoutContext(this.getContext(), help);
        ReminderItemQuery query = new ReminderItemQuery(new ReminderItemDateObjectSetQuery("ERROR", true, context.getContext()));
        ReminderItemBrowser browser = new ReminderItemBrowser(query, (LayoutContext)context);
        ErrorReminderItemCRUDWindow window = new ErrorReminderItemCRUDWindow(browser, context.getContext(), context.getHelpContext());
        this.addTab("reporting.reminder.error", model, (TabComponent)new Tab((Browser<Act>)browser, window));
    }

    private void addResendBrowser(ObjectTabPaneModel<TabComponent> model) {
        HelpContext help = this.subtopic("resend");
        DefaultLayoutContext context = new DefaultLayoutContext(this.getContext(), help);
        ReminderItemDateRangeObjectSetQuery dateRangeQuery = new ReminderItemDateRangeObjectSetQuery(null, context.getContext(), "COMPLETED", "CANCELLED");
        ReminderItemQuery query = new ReminderItemQuery(dateRangeQuery);
        ReminderItemBrowser browser = new ReminderItemBrowser(query, (LayoutContext)context);
        ResendReminderItemCRUDWindow window = new ResendReminderItemCRUDWindow(browser, context.getContext(), context.getHelpContext());
        this.addTab("reporting.reminder.resend", model, (TabComponent)new Tab((Browser<Act>)browser, window));
    }

    private class Tab
    extends BrowserCRUDWindowTab<Act> {
        public Tab(Browser<Act> browser, ReminderItemCRUDWindow window) {
            super(browser, (AbstractCRUDWindow)window, false);
        }

        public void show() {
            super.show();
            ReminderWorkspace.this.firePropertyChange("summary", null, null);
        }

        public ReminderItemCRUDWindow getWindow() {
            return (ReminderItemCRUDWindow)super.getWindow();
        }

        protected void select(Act object) {
            Act current = (Act)this.getWindow().getObject();
            super.select((IMObject)object);
            if (ReminderWorkspace.this.getSelected() == this && current != object) {
                ReminderWorkspace.this.firePropertyChange("summary", null, null);
            }
        }
    }
}

