/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.Date;
import org.openvpms.archetype.rules.patient.reminder.Reminders;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.web.component.processor.ProgressBarProcessor;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderProcessor;
import org.openvpms.web.workspace.reporting.reminder.PatientReminders;
import org.openvpms.web.workspace.reporting.reminder.ReminderBatchProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemSource;
import org.openvpms.web.workspace.reporting.reminder.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ReminderProgressBarProcessor<T extends PatientReminders>
extends ProgressBarProcessor<Reminders>
implements ReminderBatchProcessor {
    private final ReminderItemSource items;
    private final PatientReminderProcessor<T> processor;
    private boolean initialised = false;
    private boolean resend = false;
    private Statistics statistics;
    private Reminders currentReminders;
    private boolean currentError = false;
    private T currentState;
    private static final Logger log = LoggerFactory.getLogger(ReminderProgressBarProcessor.class);

    public ReminderProgressBarProcessor(ReminderItemSource items, PatientReminderProcessor<T> processor, String title) {
        super(title);
        String[] shortNames = items.getArchetypes();
        if (shortNames.length != 1 || !TypeHelper.matches((String)shortNames[0], (String)processor.getArchetype())) {
            throw new IllegalStateException("This may only query " + processor.getArchetype());
        }
        this.items = items;
        this.processor = processor;
    }

    @Override
    public String getArchetype() {
        return this.processor.getArchetype();
    }

    @Override
    public void setResend(boolean resend) {
        this.resend = resend;
    }

    @Override
    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
    }

    @Override
    public boolean hasMoreReminders() {
        return this.getIterator().hasNext();
    }

    public void process() {
        if (!this.initialised) {
            int count = this.items.count();
            this.setItems(this.items.query(), count);
            this.initialised = true;
        }
        super.process();
    }

    protected void process(Reminders reminders) {
        this.currentReminders = reminders;
        this.currentState = null;
        this.currentError = false;
        try {
            this.currentState = this.processor.prepare(reminders.getReminders(), reminders.getGroupBy(), new Date(), this.resend);
            if (!((PatientReminders)this.currentState).getReminders().isEmpty()) {
                this.process(this.currentState);
                if (this.processor.isAsynchronous()) {
                    this.setSuspend(true);
                } else {
                    this.processCompleted();
                }
            } else {
                this.processCompleted();
            }
        }
        catch (Throwable exception) {
            this.processError(exception);
        }
    }

    protected void process(T reminders) {
        this.processor.process(reminders);
    }

    protected PatientReminderProcessor<T> getProcessor() {
        return this.processor;
    }

    protected void processCompleted() {
        if (this.currentState != null) {
            if (!this.currentError) {
                this.processor.complete(this.currentState);
                if (this.statistics != null) {
                    this.processor.addStatistics((PatientReminders)this.currentState, this.statistics);
                }
            }
            super.processCompleted((Object)this.currentReminders);
        } else {
            log.error("ReminderProgressBarProcess.processCompleted() invoked with no current reminders");
        }
    }

    protected void processError(Throwable exception) {
        if (this.currentState != null) {
            this.currentError = true;
            this.processor.failed((PatientReminders)this.currentState, exception);
            if (this.statistics != null) {
                this.statistics.addErrors(((PatientReminders)this.currentState).getErrors().size());
            }
            this.notifyError(exception);
        } else {
            if (this.currentReminders != null && this.statistics != null) {
                this.statistics.addErrors(this.currentReminders.getReminders().size());
            }
            this.notifyError(exception);
        }
    }

    protected void incProcessed(Reminders reminders) {
        super.incProcessed(reminders.getReminders().size());
    }

    protected void skip() {
        if (this.currentReminders != null) {
            this.processCompleted(this.currentReminders);
        } else {
            log.error("ReminderProgressBarProcess.skip() invoked with no current reminders");
        }
    }
}

