/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.Collections;
import java.util.List;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.MailDialog;
import org.openvpms.web.component.mail.MailDialogFactory;
import org.openvpms.web.component.mail.MailEditor;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.CustomerMailContext;
import org.openvpms.web.workspace.reporting.ReportingException;
import org.openvpms.web.workspace.reporting.email.PracticeEmailAddresses;
import org.openvpms.web.workspace.reporting.reminder.AbstractPatientReminderPreviewer;
import org.openvpms.web.workspace.reporting.reminder.EmailReminders;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderEmailProcessor;

public class ReminderEmailPreviewer
extends AbstractPatientReminderPreviewer<EmailReminders> {
    public ReminderEmailPreviewer(ReminderEmailProcessor processor, HelpContext help) {
        super(processor, help);
    }

    @Override
    protected void preview(EmailReminders reminders, PatientReminderProcessor<EmailReminders> processor, HelpContext help) {
        Party practice = processor.getPractice();
        Party location = reminders.getLocation();
        Contact contact = reminders.getContact();
        Context context = reminders.createContext(practice);
        Contact from = null;
        try {
            PracticeEmailAddresses addresses = new PracticeEmailAddresses(practice, Collections.singletonList(location), "REMINDER", (ArchetypeService)ServiceHelper.getArchetypeService());
            from = addresses.getContact(location);
            if (from == null) {
                from = addresses.getContact(practice);
            }
        }
        catch (ReportingException addresses) {
            // empty catch block
        }
        final Contact available = from;
        CustomerMailContext mailContext = new CustomerMailContext(context, help){

            public List<Contact> getFromAddresses() {
                return available != null ? Collections.singletonList(available) : Collections.emptyList();
            }
        };
        MailDialogFactory factory = (MailDialogFactory)ServiceHelper.getBean(MailDialogFactory.class);
        MailDialog dialog = factory.create((MailContext)mailContext, contact, (LayoutContext)new DefaultLayoutContext(context, help));
        MailEditor editor = dialog.getMailEditor();
        editor.setSubject(reminders.getSubject(context));
        editor.setMessage(reminders.getMessage(context));
        if (processor.getConfig().getEmailAttachments()) {
            editor.addAttachment(reminders.createAttachment(context));
        }
        for (DocumentTemplate template : reminders.getEmailTemplate().getAttachments(true)) {
            Document document = template.getDocument();
            if (document == null) continue;
            editor.addAttachment(document);
        }
        dialog.show();
    }
}

