/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ActionFactory;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.openvpms.web.component.mail.DefaultMailerFactory;
import org.openvpms.web.component.mail.EmailTemplateEvaluator;
import org.openvpms.web.component.mail.MailerFactory;
import org.openvpms.web.component.service.CurrentLocationMailService;
import org.openvpms.web.component.service.MailService;
import org.openvpms.web.component.service.SimpleSMSService;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.security.mail.MailPasswordResolver;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.communication.CommunicationHelper;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.ReportingException;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderBatchProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderEmailProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderEmailProgressBarProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderExportBatchProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderExportProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemSource;
import org.openvpms.web.workspace.reporting.reminder.ReminderListBatchProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderListProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderPrintProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderPrintProgressBarProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderSMSEvaluator;
import org.openvpms.web.workspace.reporting.reminder.ReminderSMSProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderSMSProgressBarProcessor;

public class PatientReminderProcessorFactory {
    private final ReminderTypes reminderTypes;
    private final ReminderRules reminderRules;
    private final PatientRules patientRules;
    private final PracticeRules practiceRules;
    private final Party location;
    private final Party practice;
    private final HelpContext help;
    private final ReminderConfiguration config;
    private final IArchetypeService service = ServiceHelper.getArchetypeService();
    private final MailPasswordResolver passwordResolver;
    private final ActionFactory actionFactory;
    private MailerFactory factory;
    private SimpleSMSService smsService;
    private IMPrinterFactory printerFactory;
    private ReporterFactory reporterFactory;
    private CommunicationLogger logger;

    public PatientReminderProcessorFactory(Party location, Party practice, HelpContext help) {
        this.reminderRules = (ReminderRules)ServiceHelper.getBean(ReminderRules.class);
        this.patientRules = (PatientRules)ServiceHelper.getBean(PatientRules.class);
        this.practiceRules = (PracticeRules)ServiceHelper.getBean(PracticeRules.class);
        this.passwordResolver = (MailPasswordResolver)ServiceHelper.getBean(MailPasswordResolver.class);
        this.actionFactory = (ActionFactory)ServiceHelper.getBean(ActionFactory.class);
        this.location = location;
        this.practice = practice;
        this.config = this.getReminderConfig(practice);
        this.help = help;
        if (CommunicationHelper.isLoggingEnabled(practice, this.service)) {
            this.logger = (CommunicationLogger)ServiceHelper.getBean(CommunicationLogger.class);
        }
        this.reminderTypes = new ReminderTypes((ArchetypeService)this.service);
    }

    public PatientReminderProcessor<?> create(String archetype) {
        PatientReminderProcessor result;
        if (TypeHelper.matches((String)archetype, (String)"act.patientReminderItemEmail")) {
            result = this.createEmailProcessor();
        } else if (TypeHelper.matches((String)archetype, (String)"act.patientReminderItemPrint")) {
            result = this.createPrintProcessor();
        } else if (TypeHelper.matches((String)archetype, (String)"act.patientReminderItemExport")) {
            result = this.createExportProcessor();
        } else if (TypeHelper.matches((String)archetype, (String)"act.patientReminderItemSMS")) {
            result = this.createSMSProcessor();
        } else if (TypeHelper.matches((String)archetype, (String)"act.patientReminderItemList")) {
            result = this.createListProcessor();
        } else {
            throw new IllegalArgumentException("Unsupported archetype: " + archetype);
        }
        return result;
    }

    public ReminderBatchProcessor createBatchProcessor(ReminderItemSource items) {
        ReminderBatchProcessor result;
        String[] archetypes = items.getArchetypes();
        if (archetypes.length != 1) {
            throw new IllegalArgumentException("Argument 'query' must a single archetype");
        }
        String archetype = archetypes[0];
        if (TypeHelper.matches((String)archetype, (String)"act.patientReminderItemEmail")) {
            result = this.createBatchEmailProcessor(items);
        } else if (TypeHelper.matches((String)archetype, (String)"act.patientReminderItemPrint")) {
            result = this.createBatchPrintProcessor(items);
        } else if (TypeHelper.matches((String)archetype, (String)"act.patientReminderItemExport")) {
            result = this.createExportProcessor(items);
        } else if (TypeHelper.matches((String)archetype, (String)"act.patientReminderItemSMS")) {
            result = this.createBatchSMSProcessor(items);
        } else if (TypeHelper.matches((String)archetype, (String)"act.patientReminderItemList")) {
            result = this.createListProcessor(items);
        } else {
            throw new IllegalArgumentException("Unsupported archetype : " + archetype);
        }
        return result;
    }

    public Party getPractice() {
        return this.practice;
    }

    public Party getLocation() {
        return this.location;
    }

    public ReminderTypes getReminderTypes() {
        return this.reminderTypes;
    }

    public ReminderConfiguration getConfiguration() {
        return this.config;
    }

    protected HelpContext getHelp() {
        return this.help;
    }

    protected ReminderEmailProcessor createEmailProcessor() {
        EmailTemplateEvaluator evaluator = (EmailTemplateEvaluator)ServiceHelper.getBean(EmailTemplateEvaluator.class);
        return new ReminderEmailProcessor(this.getMailerFactory(), evaluator, this.getReporterFactory(), this.reminderTypes, this.practice, this.reminderRules, this.patientRules, this.practiceRules, this.service, this.config, this.logger, this.passwordResolver, this.actionFactory);
    }

    protected ReminderBatchProcessor createBatchEmailProcessor(ReminderItemSource query) {
        ReminderEmailProcessor processor = this.createEmailProcessor();
        return new ReminderEmailProgressBarProcessor(query, processor);
    }

    protected ReminderBatchProcessor createBatchPrintProcessor(ReminderItemSource query) {
        ReminderPrintProcessor processor = this.createPrintProcessor();
        return new ReminderPrintProgressBarProcessor(query, processor);
    }

    protected ReminderSMSProcessor createSMSProcessor() {
        ReminderSMSEvaluator evaluator = (ReminderSMSEvaluator)ServiceHelper.getBean(ReminderSMSEvaluator.class);
        return new ReminderSMSProcessor(this.getSMSService(), evaluator, this.reminderTypes, this.practice, this.reminderRules, this.patientRules, (ArchetypeService)this.service, this.config, this.actionFactory);
    }

    protected ReminderBatchProcessor createBatchSMSProcessor(ReminderItemSource query) {
        ReminderSMSProcessor processor = this.createSMSProcessor();
        return new ReminderSMSProgressBarProcessor(query, processor);
    }

    protected ReminderPrintProcessor createPrintProcessor() {
        ReminderPrintProcessor processor = new ReminderPrintProcessor(this.help, this.reminderTypes, this.reminderRules, this.patientRules, this.location, this.practice, this.service, this.config, this.getPrinterFactory(), this.logger, this.actionFactory);
        processor.setInteractiveAlways(true);
        return processor;
    }

    protected ReminderExportProcessor createExportProcessor() {
        return new ReminderExportProcessor(this.reminderTypes, this.reminderRules, this.patientRules, this.location, this.practice, this.service, this.config, this.logger, this.actionFactory);
    }

    protected ReminderBatchProcessor createExportProcessor(ReminderItemSource query) {
        return new ReminderExportBatchProcessor(query, this.createExportProcessor());
    }

    protected ReminderListProcessor createListProcessor() {
        return new ReminderListProcessor(this.reminderTypes, this.reminderRules, this.patientRules, this.location, this.practice, (ArchetypeService)this.service, this.config, this.getPrinterFactory(), this.logger, this.actionFactory, this.help);
    }

    protected ReminderBatchProcessor createListProcessor(ReminderItemSource query) {
        return new ReminderListBatchProcessor(query, this.createListProcessor());
    }

    protected MailerFactory getMailerFactory() {
        if (this.factory == null) {
            this.factory = new DefaultMailerFactory((MailService)ServiceHelper.getBean(CurrentLocationMailService.class), (DocumentHandlers)ServiceHelper.getBean(DocumentHandlers.class));
        }
        return this.factory;
    }

    protected SimpleSMSService getSMSService() {
        if (this.smsService == null) {
            this.smsService = (SimpleSMSService)ServiceHelper.getBean(SimpleSMSService.class);
        }
        return this.smsService;
    }

    protected IMPrinterFactory getPrinterFactory() {
        if (this.printerFactory == null) {
            this.printerFactory = (IMPrinterFactory)ServiceHelper.getBean(IMPrinterFactory.class);
        }
        return this.printerFactory;
    }

    protected ReporterFactory getReporterFactory() {
        if (this.reporterFactory == null) {
            this.reporterFactory = (ReporterFactory)ServiceHelper.getBean(ReporterFactory.class);
        }
        return this.reporterFactory;
    }

    protected CommunicationLogger getLogger() {
        return this.logger;
    }

    protected ActionFactory getActionFactory() {
        return this.actionFactory;
    }

    protected ReminderConfiguration getReminderConfig(Party practice) {
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        IMObject config = bean.getTarget("reminderConfiguration");
        if (config == null) {
            throw new ReportingException(ReportingException.ErrorCode.RemindersNotConfigured, new Object[0]);
        }
        return new ReminderConfiguration(config, (ArchetypeService)this.service);
    }
}

