/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.payment.paymentprocessor;

import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.domain.service.object.DomainObjectService;
import org.openvpms.paymentprocessor.transaction.Transaction;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.im.edit.ViewActActions;
import org.openvpms.web.component.im.query.QueryBrowser;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.payment.PaymentProcessorStatusDialog;
import org.openvpms.web.workspace.reporting.payment.TransactionCRUDWindow;

public class PaymentProcessorCRUDWindow
extends TransactionCRUDWindow {
    private static final String SEND_LINK = "button.sendLink";

    public PaymentProcessorCRUDWindow(Archetypes<FinancialAct> archetypes, QueryBrowser<FinancialAct> browser, Context context, HelpContext help) {
        super(archetypes, (ActActions<FinancialAct>)new TransactionActions(), browser, context, help);
    }

    @Override
    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(this.createPrintButton());
        buttons.add(SEND_LINK, this.action(this::sendLink, object -> this.getActions().canSendLink((FinancialAct)object)));
    }

    @Override
    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled("button.print", enable);
        buttons.setEnabled(SEND_LINK, enable && this.getActions().canSendLink((FinancialAct)this.getObject()));
    }

    protected TransactionActions getActions() {
        return (TransactionActions)super.getActions();
    }

    private void sendLink(FinancialAct object) {
        DomainObjectService service = (DomainObjectService)ServiceHelper.getBean(DomainObjectService.class);
        Transaction transaction = (Transaction)service.create((IMObject)object, Transaction.class);
        PaymentProcessorStatusDialog dialog = PaymentProcessorStatusDialog.create((Entity)transaction.getPaymentProcessor(), transaction, object, this.createLayoutContext(this.getHelpContext()), true);
        dialog.show();
    }

    protected static class TransactionActions
    extends ViewActActions<FinancialAct> {
        protected TransactionActions() {
        }

        public boolean canSendLink(FinancialAct act) {
            boolean result = false;
            if (act != null && act.isA(new String[]{"act.paymentProcessorPayment", "act.paymentProcessorRefund"}) && "SUBMITTED".equals(act.getStatus())) {
                IMObjectBean bean = this.getBean((IMObject)act);
                result = bean.getString("url") != null;
            }
            return result;
        }
    }
}

