/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.payment.eftpos;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.archetype.rules.finance.eft.EFTPOSArchetypes;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.location.LocationSelectField;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.DateRangeActQuery;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.workspace.reporting.payment.eftpos.EFTPOSResultSet;

public class EFTPOSQuery
extends DateRangeActQuery<FinancialAct> {
    private final LocationSelectField location;
    private static final SortConstraint[] DEFAULT_SORT = new SortConstraint[]{new NodeSortConstraint("startTime", false)};
    private static final ActStatuses STATUSES = new ActStatuses("act.EFTPOSPayment");

    public EFTPOSQuery(LayoutContext context) {
        super(null, null, null, EFTPOSArchetypes.TRANSACTIONS.toArray(new String[0]), STATUSES, FinancialAct.class);
        this.setDefaultSortConstraint(DEFAULT_SORT);
        this.setAuto(true);
        this.setContains(true);
        this.location = this.createLocationSelector(context.getContext());
    }

    public void setLocation(Party location) {
        this.location.setSelectedItem((Object)location);
    }

    public Extent getHeight() {
        return this.getHeight(2);
    }

    protected ResultSet<FinancialAct> createResultSet(SortConstraint[] sort) {
        Party location = (Party)this.location.getSelectedItem();
        String[] statuses = this.getStatuses();
        return new EFTPOSResultSet(this.getArchetypeConstraint(), this.getValue(), null, location, this.getLocations(), this.getFrom(), this.getTo(), statuses, this.getMaxResults(), sort);
    }

    protected List<Party> getLocations() {
        return this.location.getLocations();
    }

    protected Component createContainer() {
        return GridFactory.create((int)6);
    }

    protected void doLayout(Component container) {
        this.addSearchField(container);
        this.addStatusSelector(container);
        this.addDateRange(container);
        this.addLocation(container);
    }

    private void addLocation(Component container) {
        Label label = LabelFactory.text((String)DescriptorHelper.getDisplayName((String)"act.EFTPOSPayment", (String)"location", (ArchetypeService)this.getService()));
        container.add((Component)label);
        container.add((Component)this.location);
        this.getFocusGroup().add((Component)this.location);
    }

    private LocationSelectField createLocationSelector(Context context) {
        LocationSelectField result = new LocationSelectField(context.getUser(), context.getPractice(), true);
        result.setSelectedItem((Object)context.getLocation());
        result.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                EFTPOSQuery.this.onQuery();
            }
        });
        return result;
    }

    static {
        STATUSES.setDefault((String)null);
    }
}

