/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.payment.eftpos;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.domain.service.object.DomainObjectService;
import org.openvpms.eftpos.internal.service.EFTPOSServices;
import org.openvpms.eftpos.service.EFTPOSService;
import org.openvpms.eftpos.service.Receipts;
import org.openvpms.eftpos.terminal.Terminal;
import org.openvpms.eftpos.transaction.Payment;
import org.openvpms.eftpos.transaction.Refund;
import org.openvpms.eftpos.transaction.Transaction;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.print.PrinterContext;
import org.openvpms.web.component.im.print.PrinterContextFactory;
import org.openvpms.web.component.im.query.QueryBrowser;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.reporting.payment.TransactionCRUDWindow;
import org.openvpms.web.workspace.reporting.payment.eftpos.LastReceiptPrinter;

public class EFTPOSCRUDWindow
extends TransactionCRUDWindow {
    private static final String LAST_RECEIPT = "reporting.eftpos.print.lastReceipt";

    public EFTPOSCRUDWindow(Archetypes<FinancialAct> archetypes, QueryBrowser<FinancialAct> browser, Context context, HelpContext help) {
        super(archetypes, browser, context, help);
    }

    @Override
    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(LAST_RECEIPT, this::onPrintLastReceipt);
    }

    @Override
    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(LAST_RECEIPT, enable);
    }

    private void onPrintLastReceipt() {
        Act object = (Act)this.getObject();
        if (object != null) {
            EFTPOSServices services;
            EFTPOSService service;
            Receipts receipts;
            String merchantReceipt = null;
            String merchantReceiptWithSig = null;
            String customerReceipt = null;
            DomainObjectService domainObjectService = (DomainObjectService)ServiceHelper.getBean(DomainObjectService.class);
            Transaction transaction = object.isA("act.EFTPOSPayment") ? (Transaction)domainObjectService.create((IMObject)object, Payment.class) : (Transaction)domainObjectService.create((IMObject)object, Refund.class);
            Terminal terminal = transaction.getTerminal();
            if (terminal != null && (receipts = (service = (services = (EFTPOSServices)ServiceHelper.getBean(EFTPOSServices.class)).getService((Entity)terminal)).getLastReceipts(transaction)) != null) {
                merchantReceipt = receipts.getMerchantReceipt(false);
                merchantReceiptWithSig = receipts.getMerchantReceipt(true);
                customerReceipt = receipts.getCustomerReceipt();
            }
            if (merchantReceiptWithSig != null && merchantReceipt != null && customerReceipt != null) {
                PrinterContext printerContext = ((PrinterContextFactory)ServiceHelper.getBean(PrinterContextFactory.class)).create();
                LastReceiptPrinter printer = new LastReceiptPrinter(merchantReceipt, merchantReceiptWithSig, customerReceipt, printerContext, this.getContext(), this.getHelpContext());
                printer.setMailContext(this.getMailContext());
                printer.print();
            } else {
                InformationDialog.show((String)Messages.get((String)LAST_RECEIPT), (String)Messages.get((String)"reporting.eftpos.print.noreceipts"));
            }
        }
    }
}

