/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.payment;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Button;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.im.edit.ViewActActions;
import org.openvpms.web.component.im.query.QueryBrowser;
import org.openvpms.web.component.im.view.IMObjectViewerDialog;
import org.openvpms.web.component.im.view.Selection;
import org.openvpms.web.component.im.view.ViewResultSetDialog;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workspace.ResultSetCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.InformationDialogBuilder;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.CustomerMailContext;

public class TransactionCRUDWindow
extends ResultSetCRUDWindow<FinancialAct> {
    private final QueryBrowser<FinancialAct> browser;
    private static final String SOURCE_ID = "button.source";

    public TransactionCRUDWindow(Archetypes<FinancialAct> archetypes, QueryBrowser<FinancialAct> browser, Context context, HelpContext help) {
        this(archetypes, (ActActions<FinancialAct>)ViewActActions.getInstance(), browser, context, help);
    }

    protected TransactionCRUDWindow(Archetypes<FinancialAct> archetypes, ActActions<FinancialAct> actions, QueryBrowser<FinancialAct> browser, Context context, HelpContext help) {
        super(archetypes, actions, browser.getQuery(), null, context, help);
        this.browser = browser;
    }

    public Party getCustomer() {
        Party result = null;
        FinancialAct object = (FinancialAct)this.getObject();
        if (object != null) {
            result = this.getCustomer(object);
        }
        return result;
    }

    public void view() {
        this.setResultSet(this.browser.getResultSet());
        super.view();
    }

    protected void layoutButtons(ButtonSet buttons) {
        buttons.add(this.createViewButton());
        buttons.add(SOURCE_ID, this.action(this::viewPaymentOrRefund));
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        buttons.setEnabled("view", enable);
        buttons.setEnabled(SOURCE_ID, enable);
    }

    protected ViewResultSetDialog<FinancialAct> createViewResultSetDialog(String title, FinancialAct object, boolean edit) {
        return new SourceViewResultSetDialog(title, object, edit);
    }

    private Party getCustomer(FinancialAct object) {
        IMObjectBean bean = this.getBean((IMObject)object);
        Party result = (Party)bean.getTarget("customer", Party.class);
        return result;
    }

    private void viewPaymentOrRefund(FinancialAct object) {
        ArrayList<Selection> selections = new ArrayList<Selection>();
        FinancialAct act = this.getPaymentOrRefund(object, selections);
        if (act != null) {
            LocalContext context = LocalContext.copy((Context)this.getContext());
            context.setCustomer(this.getCustomer());
            CustomerMailContext mailContext = new CustomerMailContext((Context)context);
            IMObjectViewerDialog dialog = new IMObjectViewerDialog((Context)context, (MailContext)mailContext, this.getHelpContext());
            dialog.disableHyperlinks();
            dialog.setObject((IMObject)act, selections);
            dialog.show();
        } else {
            ((InformationDialogBuilder)InformationDialog.newDialog().titleKey("reporting.payment.sourcenotfound", new Object[0])).show();
        }
    }

    private FinancialAct getPaymentOrRefund(FinancialAct act, List<Selection> selection) {
        IMObjectBean itemBean;
        FinancialAct parent = null;
        IMObjectBean transactionBean = this.getBean((IMObject)act);
        FinancialAct item = (FinancialAct)transactionBean.getSource("transaction", FinancialAct.class);
        if (item != null && (parent = (FinancialAct)(itemBean = this.getBean((IMObject)item)).getSource("transaction", FinancialAct.class)) != null) {
            selection.add(new Selection("items", null));
            selection.add(new Selection(null, itemBean.getObject("transaction", ActRelationship.class)));
            selection.add(new Selection("transactions", null));
            selection.add(new Selection(null, transactionBean.getObject("transaction", ActRelationship.class)));
        }
        return parent;
    }

    protected class SourceViewResultSetDialog
    extends ResultSetCRUDWindow.IMObjectViewResultSetDialog {
        public SourceViewResultSetDialog(String title, FinancialAct object, boolean edit) {
            super((ResultSetCRUDWindow)TransactionCRUDWindow.this, title, (IMObject)object, edit);
            ButtonSet buttons = this.getButtons();
            Button button = buttons.create(TransactionCRUDWindow.SOURCE_ID, this::viewPaymentOrRefund);
            buttons.add(button, 0);
        }

        private void viewPaymentOrRefund() {
            FinancialAct selected = (FinancialAct)this.getSelected();
            if (selected != null) {
                TransactionCRUDWindow.this.viewPaymentOrRefund(selected);
            }
        }
    }
}

