/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.insurance;

import java.util.ArrayList;
import java.util.Date;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.OrConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.ActResultSet;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.QueryHelper;

public class ClaimResultSet
extends ActResultSet<Act> {
    private final String id;
    private final Party insurer;
    private final String gapStatus;

    public ClaimResultSet(ShortNameConstraint archetypes, String id, Party location, Party insurer, User clinician, Date from, Date to, String[] statuses, String gapStatus, int pageSize, SortConstraint[] sort) {
        super(archetypes, ClaimResultSet.getParticipants(location, clinician), from, to, statuses, false, null, pageSize, sort);
        this.id = id;
        this.insurer = insurer;
        this.gapStatus = gapStatus;
    }

    protected ArchetypeQuery createQuery() {
        ArchetypeQuery query = super.createQuery();
        if (this.gapStatus != null) {
            query.add((IConstraint)Constraints.eq((String)"status2", (Object)this.gapStatus));
        }
        if (this.id != null) {
            query.add((IConstraint)Constraints.leftJoin((String)"insurerId", (String)"claimId"));
            query.add((IConstraint)Constraints.leftJoin((String)"policy", (String)"p").add((IConstraint)Constraints.leftJoin((String)"target", (String)"t").add((IConstraint)Constraints.leftJoin((String)"insurerId", (String)"policyNumber"))));
            OrConstraint or = Constraints.or((IConstraint[])new IConstraint[]{Constraints.eq((String)"claimId.identity", (Object)this.id), Constraints.eq((String)"policyNumber.identity", (Object)this.id)});
            Long actId = this.getId(this.id);
            if (actId != null) {
                or.add((IConstraint)Constraints.eq((String)"id", (Object)actId));
            }
            query.add((IConstraint)or);
        }
        if (this.insurer != null) {
            query.add((IConstraint)Constraints.join((String)"policy").add((IConstraint)Constraints.join((String)"target").add((IConstraint)Constraints.join((String)"insurer").add((IConstraint)Constraints.eq((String)"entity", (Object)this.insurer)))));
        }
        return query;
    }

    private static ParticipantConstraint[] getParticipants(Party location, User clinician) {
        ArrayList list = new ArrayList();
        if (location != null) {
            QueryHelper.addParticipantConstraint(list, (String)"location", (String)"participation.location", (Entity)location);
        }
        if (clinician != null) {
            QueryHelper.addParticipantConstraint(list, (String)"clinician", (String)"participation.clinician", (Entity)clinician);
        }
        return list.toArray(new ParticipantConstraint[0]);
    }
}

