/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.insurance;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.report.ReportException;
import org.openvpms.report.ReportFactory;
import org.openvpms.report.i18n.ReportMessages;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.print.PrinterContext;
import org.openvpms.web.component.im.print.PrinterContextFactory;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.print.InteractivePrinter;
import org.openvpms.web.component.print.Printer;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.insurance.InsuranceCRUDWindow;
import org.openvpms.web.workspace.reporting.insurance.ClaimQuery;
import org.openvpms.web.workspace.reporting.report.SQLReportPrinter;

public class ClaimCRUDWindow
extends InsuranceCRUDWindow {
    private final ClaimQuery query;
    private static final String REPORT_ID = "button.report";
    private static final String REPORT_TYPE = "INSURANCE_CLAIMS_REPORT";

    public ClaimCRUDWindow(Context context, HelpContext help, ClaimQuery query) {
        super(true, context, help);
        this.query = query;
    }

    @Override
    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(REPORT_ID, this::onReport);
    }

    protected IMObjectEditor createEditor(Act object, LayoutContext context) {
        this.updateContext(object, context);
        return super.createEditor((IMObject)object, context);
    }

    protected void onReport() {
        String name;
        Context context = this.getContext();
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator(REPORT_TYPE, context);
        DocumentTemplate template = locator.getTemplate();
        Lookup lookup = ServiceHelper.getLookupService().getLookup("lookup.documentTemplateType", REPORT_TYPE);
        String string = name = lookup != null ? lookup.getName() : REPORT_TYPE;
        if (template == null) {
            throw new ReportException(ReportMessages.noTemplateForType((String)name));
        }
        FileNameFormatter formatter = (FileNameFormatter)ServiceHelper.getBean(FileNameFormatter.class);
        DataSource dataSource = (DataSource)ServiceHelper.getBean((String)"reportingDataSource", DataSource.class);
        ReportFactory reportFactory = (ReportFactory)ServiceHelper.getBean(ReportFactory.class);
        PrinterContext printerContext = ((PrinterContextFactory)ServiceHelper.getBean(PrinterContextFactory.class)).create();
        SQLReportPrinter printer = new SQLReportPrinter(template, context, reportFactory, formatter, dataSource, printerContext);
        Map<String, Object> parameters = this.getParameters();
        printer.setParameters(parameters);
        String title = Messages.format((String)"imobject.print.title", (Object[])new Object[]{name});
        HelpContext help = this.getHelpContext().subtopic("report");
        InteractivePrinter iPrinter = new InteractivePrinter(title, (Printer)printer, context, help);
        iPrinter.setMailContext(this.getMailContext());
        iPrinter.print();
    }

    private Map<String, Object> getParameters() {
        User clinician;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String id = StringUtils.removeEnd((String)this.query.getValue(), (String)"*");
        parameters.put("id", id);
        parameters.put("from", this.query.getFrom());
        parameters.put("to", this.query.getTo());
        Party location = this.query.getLocation();
        if (location != null) {
            parameters.put("locationId", location.getId());
            parameters.put("locationName", location.getName());
        }
        parameters.put("status", this.query.getStatus());
        parameters.put("gapStatus", this.query.getGapStatus());
        Party insurer = this.query.getInsurer();
        if (insurer != null) {
            parameters.put("insurerId", insurer.getId());
            parameters.put("insurerName", insurer.getName());
        }
        if ((clinician = this.query.getClinician()) != null) {
            parameters.put("clinicianId", clinician.getId());
            parameters.put("clinicianName", clinician.getName());
        }
        return parameters;
    }

    private void updateContext(Act object, LayoutContext context) {
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        IMObjectBean claimBean = service.getBean((IMObject)object);
        Party patient = (Party)claimBean.getTarget("patient", Party.class);
        if (patient == null) {
            throw new IllegalStateException("Cannot determine patient associated with claim");
        }
        Act policy = (Act)claimBean.getTarget("policy", Act.class);
        if (policy == null) {
            throw new IllegalStateException("Cannot determine policy associated with claim");
        }
        IMObjectBean policyBean = service.getBean((IMObject)policy);
        Party customer = (Party)policyBean.getTarget("customer", Party.class);
        if (customer == null) {
            throw new IllegalStateException("Cannot determine customer associated with claim");
        }
        context.getContext().setCustomer(customer);
        context.getContext().setPatient(patient);
    }
}

