/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product.stock;

import java.util.Objects;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.product.stock.StockTransferItemEditor;

public class StockTransferEditor
extends ActEditor {
    private static final String FROM = "stockLocation";
    private static final String TO = "to";

    public StockTransferEditor(Act act, IMObject parent, LayoutContext context) {
        super(act, parent, context);
    }

    protected void onLayoutCompleted() {
        ParticipationEditor from = this.getParticipationEditor(FROM, false);
        ParticipationEditor to = this.getParticipationEditor(TO, false);
        from.addModifiableListener(modifiable -> this.transferFromChanged((Party)from.getEntity()));
        to.addModifiableListener(modifiable -> this.transferToChanged((Party)to.getEntity()));
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.checkLocations(validator);
    }

    private boolean checkLocations(Validator validator) {
        Party to;
        boolean result = false;
        Party from = (Party)this.getParticipant(FROM);
        if (!Objects.equals(from, to = (Party)this.getParticipant(TO))) {
            result = true;
        } else {
            validator.add((Modifiable)this, new ValidatorError(Messages.get((String)"product.stock.same")));
        }
        return result;
    }

    private void transferFromChanged(Party location) {
        for (IMObjectEditor itemEditor : this.getItems().getEditors()) {
            StockTransferItemEditor editor = (StockTransferItemEditor)itemEditor;
            editor.setTransferFrom(location);
        }
    }

    private void transferToChanged(Party location) {
        for (IMObjectEditor itemEditor : this.getItems().getEditors()) {
            StockTransferItemEditor editor = (StockTransferItemEditor)itemEditor;
            editor.setTransferTo(location);
        }
    }
}

