/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product.stock;

import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ObjectSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractEntityResultSet;
import org.openvpms.web.component.im.query.ObjectSetQueryExecutor;
import org.openvpms.web.component.im.query.QueryExecutor;

public class StockExportResultSet
extends AbstractEntityResultSet<ObjectSet> {
    private final Entity stockLocation;
    private final Entity productType;
    private final String incomeType;
    private final String productGroup;

    public StockExportResultSet(ShortNameConstraint archetypes, String value, boolean searchIdentities, Entity stockLocation, Entity productType, String incomeType, String productGroup, SortConstraint[] sort, int rows) {
        super(archetypes, value, searchIdentities, null, sort, rows, false, (QueryExecutor)new ObjectSetQueryExecutor());
        archetypes.setAlias("product");
        this.stockLocation = stockLocation;
        this.productType = productType;
        this.incomeType = incomeType;
        this.productGroup = productGroup;
    }

    protected ArchetypeQuery createQuery() {
        ArchetypeQuery query = super.createQuery();
        query.add((IConstraint)Constraints.join((String)"stockLocations", (String)"relationship").add((IConstraint)Constraints.eq((String)"relationship.target", (Reference)this.stockLocation.getObjectReference())));
        if (this.productType != null) {
            query.add((IConstraint)Constraints.join((String)"type").add((IConstraint)Constraints.eq((String)"target", (Object)this.productType)));
        }
        if (this.incomeType != null) {
            query.add((IConstraint)Constraints.join((String)"classifications", (BaseArchetypeConstraint)Constraints.shortName((String)"incomeType", (String)"lookup.productIncomeType")).add((IConstraint)Constraints.eq((String)"code", (Object)this.incomeType)));
        }
        if (this.productGroup != null) {
            query.add((IConstraint)Constraints.join((String)"classifications", (BaseArchetypeConstraint)Constraints.shortName((String)"productGroup", (String)"lookup.productGroup")).add((IConstraint)Constraints.eq((String)"code", (Object)this.productGroup)));
        }
        query.add((IConstraint)new ObjectSelectConstraint("product"));
        query.add((IConstraint)new ObjectSelectConstraint("relationship"));
        return query;
    }
}

