/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product.stock;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.openvpms.archetype.rules.stock.io.StockData;
import org.openvpms.component.business.dao.im.Page;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryAdapter;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetAdapter;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.util.LookupNameHelper;
import org.openvpms.web.workspace.product.stock.StockExportObjectSetQuery;

public class StockExportQuery
extends QueryAdapter<ObjectSet, StockData> {
    public StockExportQuery(Party stockLocation) {
        super((Query)new StockExportObjectSetQuery(stockLocation), StockData.class);
    }

    public void setStockLocation(Party stockLocation) {
        this.getQuery().setStockLocation(stockLocation);
    }

    public Party getStockLocation() {
        return this.getQuery().getStockLocation();
    }

    public void setProductType(Entity productType) {
        this.getQuery().setProductType(productType);
    }

    public void setProductGroup(String productGroup) {
        this.getQuery().setProductGroup(productGroup);
    }

    public void setIncomeType(String incomeType) {
        this.getQuery().setIncomeType(incomeType);
    }

    public StockExportObjectSetQuery getQuery() {
        return (StockExportObjectSetQuery)super.getQuery();
    }

    protected ResultSet<StockData> convert(ResultSet<ObjectSet> set) {
        return new ResultSetAdapter<ObjectSet, StockData>(set){

            protected IPage<StockData> convert(IPage<ObjectSet> page) {
                Party stockLocation = StockExportQuery.this.getQuery().getStockLocation();
                boolean zeroNegativeQuantities = StockExportQuery.this.getQuery().getZeroNegativeQuantities();
                ArrayList<StockData> objects = new ArrayList<StockData>();
                for (ObjectSet set : page.getResults()) {
                    Product product = (Product)set.get("product");
                    EntityLink relationship = (EntityLink)set.get("relationship");
                    StockData data = StockExportQuery.this.createStockData((Entity)stockLocation, product, relationship, zeroNegativeQuantities);
                    objects.add(data);
                }
                return new Page(objects, page.getFirstResult(), page.getPageSize(), page.getTotalResults());
            }
        };
    }

    private StockData createStockData(Entity stockLocation, Product product, EntityLink relationship, boolean zeroNegativeQuantities) {
        String sellingUnits = LookupNameHelper.getName((IMObject)product, (String)"sellingUnits");
        IMObjectBean bean = IMObjectHelper.getBean((IMObject)relationship);
        BigDecimal quantity = bean.getBigDecimal("quantity", BigDecimal.ZERO);
        BigDecimal newQuantity = quantity.signum() == -1 && zeroNegativeQuantities ? BigDecimal.ZERO : quantity;
        return new StockData(stockLocation.getId(), stockLocation.getName(), product.getId(), product.getName(), sellingUnits, quantity, newQuantity);
    }
}

