/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product.stock;

import java.util.List;
import nextapp.echo2.app.filetransfer.UploadListener;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.stock.StockUpdater;
import org.openvpms.archetype.rules.stock.io.StockDataImporter;
import org.openvpms.archetype.rules.stock.io.StockDataSet;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.doc.DocumentUploadListener;
import org.openvpms.web.component.im.doc.UploadDialog;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActEditDialog;
import org.openvpms.web.component.retry.Retryable;
import org.openvpms.web.component.retry.Retryer;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.ActCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.product.stock.StockExportDialog;
import org.openvpms.web.workspace.product.stock.StockIOHelper;
import org.openvpms.web.workspace.product.stock.StockImportErrorDialog;

public class StockCRUDWindow
extends ActCRUDWindow<Act> {
    private final UserRules rules = (UserRules)ServiceHelper.getBean(UserRules.class);
    private static final String EXPORT_ID = "button.export";
    private static final String IMPORT_ID = "button.import";

    public StockCRUDWindow(Archetypes<Act> archetypes, Context context, HelpContext help) {
        super(archetypes, ActActions.edit(), context, help);
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(this.createPostButton());
        buttons.add(this.createPrintButton());
        buttons.add(this.createMailButton());
        User user = this.getContext().getUser();
        if (user != null && this.rules.canEdit(user, "act.stockAdjust")) {
            buttons.add(EXPORT_ID, this::onExport);
            buttons.add(IMPORT_ID, this::onImport);
        }
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        boolean enableEdit = false;
        boolean enableDeletePost = false;
        if (enable) {
            Act object = (Act)this.getObject();
            ActActions actions = this.getActions();
            enableEdit = actions.canEdit(object);
            enableDeletePost = actions.canDelete(object);
        }
        buttons.setEnabled("button.edit", enableEdit);
        buttons.setEnabled("button.delete", enableDeletePost);
        buttons.setEnabled("button.post", enableDeletePost);
        this.enablePrintPreview(buttons, enable);
    }

    protected EditDialog createEditDialog(IMObjectEditor editor) {
        return new ActEditDialog(editor, this.getContext());
    }

    protected void onPosted(final Act act) {
        Retryer.run((Retryable)new Retryable(){

            public boolean run() {
                StockUpdater updater = new StockUpdater((IArchetypeService)ServiceHelper.getArchetypeService());
                updater.update(act);
                return true;
            }
        });
    }

    private void onExport() {
        HelpContext help = this.getHelpContext().subtopic("export");
        StockExportDialog dialog = new StockExportDialog(this.createLayoutContext(help), help);
        dialog.show();
    }

    private void onImport() {
        final HelpContext help = this.getHelpContext().subtopic("import");
        DocumentUploadListener listener = new DocumentUploadListener(){

            protected void upload(Document document) {
                try {
                    StockCRUDWindow.this.importDocument(document, help);
                }
                catch (Throwable exception) {
                    ErrorHelper.show((Throwable)exception);
                }
            }
        };
        UploadDialog dialog = new UploadDialog((UploadListener)listener, help.subtopic("upload"));
        dialog.show();
    }

    private void importDocument(Document document, HelpContext help) {
        StockDataSet data;
        int maxLength;
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        StockDataImporter importer = new StockDataImporter((IArchetypeService)service, (DocumentHandlers)ServiceHelper.getBean(DocumentHandlers.class), StockIOHelper.getFieldSeparator(this.getContext().getPractice()));
        String reason = Messages.format((String)"product.stock.import.reason", (Object[])new Object[]{document.getName()});
        NodeDescriptor node = DescriptorHelper.getNode((String)"act.stockAdjust", (String)"reason", (ArchetypeService)service);
        int n = maxLength = node != null ? node.getMaxLength() : 255;
        if (maxLength > 0 && reason.length() > maxLength) {
            reason = reason.substring(0, maxLength);
        }
        if ((data = importer.load(document, reason)).getAdjustment() != null) {
            this.onRefresh((IMObject)data.getAdjustment());
        } else if (!data.getErrors().isEmpty()) {
            List errors = data.getErrors();
            StockImportErrorDialog dialog = new StockImportErrorDialog(errors, help.subtopic("errors"));
            dialog.show();
        } else {
            InformationDialog.show((String)Messages.get((String)"product.stock.import.title"), (String)Messages.get((String)"product.stock.import.nochanges"));
        }
    }
}

