/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product.stock;

import java.math.BigDecimal;
import java.util.List;
import org.openvpms.archetype.rules.stock.StockRules;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.im.edit.act.ActItemEditor;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class StockAdjustItemEditor
extends ActItemEditor {
    private final SimpleProperty currentQuantity;
    private final StockRules rules = (StockRules)ServiceHelper.getBean(StockRules.class);
    private Party stockLocation;

    public StockAdjustItemEditor(Act act, Act parent, LayoutContext context) {
        super(act, parent, context);
        this.currentQuantity = new SimpleProperty("fromQuantity", BigDecimal.class);
        this.currentQuantity.setDisplayName(Messages.get((String)"product.stock.quantity"));
        this.currentQuantity.setReadOnly(true);
        if (parent != null) {
            IMObjectBean bean = this.getBean((IMObject)parent);
            this.setStockLocation((Party)this.getObject(bean.getTargetRef("stockLocation")));
        }
        this.updateCurrentQuantity(this.getProduct());
    }

    public void setStockLocation(Party location) {
        this.stockLocation = location;
    }

    protected void productModified(Product product) {
        this.updateCurrentQuantity(product);
        this.notifyProductListener(product);
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new ActItemEditor.LayoutStrategy(){

            protected ComponentSet createComponentSet(IMObject object, List<Property> properties, LayoutContext context) {
                ComponentSet set = super.createComponentSet(object, properties, context);
                ComponentState component = this.createComponent((Property)StockAdjustItemEditor.this.currentQuantity, object, context);
                set.add(component);
                return set;
            }
        };
    }

    private void updateCurrentQuantity(Product product) {
        BigDecimal quantity = BigDecimal.ZERO;
        try {
            if (this.stockLocation != null && product != null) {
                quantity = this.rules.getStock(product, this.stockLocation);
            }
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show((Throwable)exception);
        }
        this.currentQuantity.setValue((Object)quantity);
    }
}

