/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product.io;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.product.io.ProductData;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.table.PagedIMTableModel;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;

public class ProductImportErrorDialog
extends PopupDialog {
    public ProductImportErrorDialog(List<ProductData> errors, HelpContext help) {
        super(Messages.get((String)"product.import.error.title"), "BrowserDialog", OK, help);
        this.setModal(true);
        ListResultSet resultSet = new ListResultSet(errors, 20);
        PagedIMTableModel model = new PagedIMTableModel((IMTableModel)new ErrorTableModel());
        PagedIMTable table = new PagedIMTable((IMTableModel)model, (ResultSet)resultSet);
        Label message = LabelFactory.create((String)"product.import.error.message");
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{message, table.getComponent()})}));
    }

    private static class ErrorTableModel
    extends AbstractIMTableModel<ProductData> {
        private static final int ID = 0;
        private static final int NAME = 1;
        private static final int LINE = 2;
        private static final int ERROR = 3;

        public ErrorTableModel() {
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            model.addColumn(ErrorTableModel.createTableColumn((int)0, (String)"product.import.id"));
            model.addColumn(ErrorTableModel.createTableColumn((int)1, (String)"product.import.name"));
            model.addColumn(ErrorTableModel.createTableColumn((int)2, (String)"product.import.line"));
            model.addColumn(ErrorTableModel.createTableColumn((int)3, (String)"product.import.error"));
            this.setTableColumnModel((TableColumnModel)model);
        }

        protected Object getValue(ProductData object, TableColumn column, int row) {
            Object result;
            switch (column.getModelIndex()) {
                case 0: {
                    result = object.getId();
                    break;
                }
                case 1: {
                    result = object.getName();
                    break;
                }
                case 3: {
                    result = object.getError();
                    break;
                }
                case 2: {
                    result = object.getErrorLine();
                    break;
                }
                default: {
                    result = null;
                }
            }
            return result;
        }

        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            return null;
        }
    }
}

