/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.visit;

import nextapp.echo2.app.Component;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.patient.charge.VisitChargeEditor;
import org.openvpms.web.workspace.patient.mr.PatientPrescriptionCRUDWindow;
import org.openvpms.web.workspace.patient.mr.prescription.PrescriptionDispenser;

public class VisitPrescriptionCRUDWindow
extends PatientPrescriptionCRUDWindow {
    private VisitChargeEditor chargeEditor;

    public VisitPrescriptionCRUDWindow(Archetypes<Act> archetypes, Context context, HelpContext help) {
        super(archetypes, null, context, help);
        this.setActions((IMObjectActions)new Actions());
    }

    public void setChargeEditor(VisitChargeEditor chargeEditor) {
        this.chargeEditor = chargeEditor;
    }

    @Override
    protected void onDispense() {
        if (this.chargeEditor == null) {
            this.showStatusError((Act)this.getObject(), "patient.prescription.dispense", "patient.prescription.noinvoice");
        } else {
            Act prescription = (Act)IMObjectHelper.reload((IMObject)this.getObject());
            if (prescription != null) {
                PrescriptionDispenser dispenser = new PrescriptionDispenser(this.getContext(), this.getHelpContext());
                dispenser.dispense(prescription, (CustomerChargeActEditor)this.chargeEditor, () -> this.onSaved((Act)this.getObject(), false));
            }
        }
    }

    protected Component doLayout() {
        return this.getContainer();
    }

    protected LayoutContext createViewLayoutContext() {
        LayoutContext context = super.createViewLayoutContext();
        context.setContextSwitchListener(null);
        return context;
    }

    private class Actions
    extends PatientPrescriptionCRUDWindow.PrescriptionActions {
        private Actions() {
        }

        @Override
        public boolean canDispense(Act act) {
            return VisitPrescriptionCRUDWindow.this.chargeEditor != null && super.canDispense(act);
        }
    }
}

