/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.visit;

import java.util.List;
import nextapp.echo2.app.Component;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.im.edit.AlertManager;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorOperation;
import org.openvpms.web.component.im.edit.IMObjectEditorSaver;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.view.IMObjectViewer;
import org.openvpms.web.component.workspace.AbstractCRUDWindow;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.OrderChargeManager;
import org.openvpms.web.workspace.customer.order.OrderCharger;
import org.openvpms.web.workspace.customer.order.OrderChargerFactory;
import org.openvpms.web.workspace.patient.charge.VisitChargeEditor;
import org.openvpms.web.workspace.patient.visit.VisitEditorTab;

public class VisitChargeCRUDWindow
extends AbstractCRUDWindow<FinancialAct>
implements VisitEditorTab {
    public static final String COMPLETED_ID = "button.completed";
    public static final String IN_PROGRESS_ID = "button.inprogress";
    public static final String INVOICE_ORDERS_ID = "button.invoiceOrders";
    public static final String SUBMIT_INVESTIGATIONS_ID = "button.submitInvestigations";
    private final Act event;
    private final OrderChargeManager manager;
    private final AlertManager alerts;
    private final Component container = ColumnFactory.create();
    private VisitChargeEditor editor;
    private boolean posted;
    private int id;
    private boolean autoChargeOrders = true;

    public VisitChargeCRUDWindow(Act event, Context context, HelpContext help) {
        super(Archetypes.create((String)"act.customerAccountChargesInvoice", FinancialAct.class), (IMObjectActions)ActActions.edit(), context, help);
        this.event = event;
        OrderChargerFactory factory = (OrderChargerFactory)ServiceHelper.getBean(OrderChargerFactory.class);
        OrderCharger charger = factory.create(context.getCustomer(), context.getPatient(), context, help.subtopic("order"));
        this.alerts = new AlertManager(this.container, 2);
        this.manager = new OrderChargeManager(charger, this.alerts.getListener());
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public void setObject(FinancialAct object) {
        this.container.removeAll();
        if (this.editor != null) {
            this.editor.setAddItemListener(null);
        }
        if (object != null) {
            List path = this.editor != null ? this.editor.getSelectionPath() : null;
            this.posted = "POSTED".equals(object.getStatus());
            if (this.posted) {
                IMObjectViewer viewer = new IMObjectViewer((IMObject)object, (LayoutContext)new DefaultLayoutContext(this.getContext(), this.getHelpContext()));
                this.container.add(viewer.getComponent());
                if (path != null) {
                    viewer.setSelectionPath(path);
                }
                this.editor = null;
            } else {
                HelpContext edit = this.createEditTopic((IMObject)object);
                this.editor = this.createVisitChargeEditor(object, this.event, this.createLayoutContext(edit));
                this.editor.setAlertListener(this.alerts.getListener());
                this.editor.setAddItemListener(this::autoSave);
                this.container.add(this.editor.getComponent());
                if (path != null) {
                    this.editor.setSelectionPath(path);
                }
            }
        } else {
            this.editor = null;
        }
        this.manager.clear();
        super.setObject((IMObject)object);
    }

    public VisitChargeEditor getEditor() {
        return this.editor;
    }

    public void create() {
        if (this.editor == null) {
            IArchetypeRuleService archetypeService = ServiceHelper.getArchetypeService();
            FinancialAct invoice = (FinancialAct)archetypeService.create("act.customerAccountChargesInvoice", FinancialAct.class);
            this.setObject(invoice);
        }
    }

    @Override
    public void show() {
        if (this.editor != null) {
            if (this.autoChargeOrders) {
                this.manager.charge(this.editor);
            } else {
                this.manager.check();
            }
            this.editor.getFocusGroup().setFocus();
        }
    }

    @Override
    public boolean save() {
        return this.save(true);
    }

    @Override
    public CRUDWindow<? extends Act> getWindow() {
        return this;
    }

    public boolean inProgress() {
        boolean result = false;
        if (this.editor != null && !this.posted) {
            this.editor.setStatus("IN_PROGRESS");
            result = this.save();
        }
        return result;
    }

    public boolean complete() {
        boolean result = false;
        if (this.editor != null && !this.posted) {
            this.editor.setStatus("COMPLETED");
            result = this.save();
        }
        return result;
    }

    public void chargeOrders() {
        if (!this.posted) {
            this.manager.chargeSelected(this.editor);
        }
    }

    public void submitInvestigations() {
        if (!this.posted && this.editor != null && this.save(false)) {
            this.editor.submitInvestigations();
        }
    }

    public void setAutoChargeOrders(boolean charge) {
        this.autoChargeOrders = charge;
    }

    public boolean isAutoChargeOrders() {
        return this.autoChargeOrders;
    }

    protected boolean save(boolean checkOrders) {
        boolean saved;
        boolean bl = saved = this.editor == null || this.posted || this.doSave();
        if (checkOrders) {
            this.manager.check();
        }
        return saved;
    }

    protected boolean doSave() {
        IMObjectEditorSaver.SaveOperation strategy = new IMObjectEditorSaver.SaveOperation(){

            public void apply(IMObjectEditor editor) {
                super.apply(editor);
                VisitChargeCRUDWindow.this.manager.save();
            }

            protected boolean reload(IMObjectEditor editor) {
                FinancialAct act = (FinancialAct)IMObjectHelper.reload((IMObject)editor.getObject());
                VisitChargeCRUDWindow.this.setObject(act);
                return act != null;
            }
        };
        IMObjectEditorSaver saver = new IMObjectEditorSaver((IMObjectEditorOperation)strategy);
        boolean saved = saver.save((IMObjectEditor)this.editor);
        this.manager.clear();
        FinancialAct object = (FinancialAct)this.getObject();
        this.posted = object != null && "POSTED".equals(((FinancialAct)this.getObject()).getStatus());
        return saved;
    }

    protected Component doLayout() {
        this.enableButtons(this.getButtons(), this.getObject() != null);
        return this.container;
    }

    protected VisitChargeEditor createVisitChargeEditor(FinancialAct charge, Act event, LayoutContext context) {
        return new VisitChargeEditor(charge, event, context);
    }

    protected void layoutButtons(ButtonSet buttons) {
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        if (buttons != null) {
            if (enable) {
                enable = !this.posted;
            }
            buttons.setEnabled(IN_PROGRESS_ID, enable);
            buttons.setEnabled(COMPLETED_ID, enable);
            buttons.setEnabled(INVOICE_ORDERS_ID, enable);
            buttons.setEnabled(SUBMIT_INVESTIGATIONS_ID, enable);
        }
    }

    protected void autoSave() {
        FinancialAct object = this.editor.getObject();
        if (!object.isNew() && !"POSTED".equals(this.editor.getStatus()) && this.editor.isValid()) {
            this.save();
        }
    }
}

