/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.vetcheck;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.apache.commons.lang3.mutable.MutableObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.component.retry.Retryable;
import org.openvpms.web.component.retry.Retryer;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.InformationDialogBuilder;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.frame.MonitoredFrame;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.vetcheck.AbstractVetCheckDialog;
import org.openvpms.web.workspace.patient.vetcheck.VetCheckLink;
import org.openvpms.web.workspace.patient.vetcheck.VetCheckRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VetCheckDialog
extends AbstractVetCheckDialog {
    private final VetCheckRules rules = (VetCheckRules)ServiceHelper.getBean(VetCheckRules.class);
    private final Party patient;
    private final Party location;
    private final Context context;
    private static final Logger log = LoggerFactory.getLogger(VetCheckDialog.class);

    public VetCheckDialog(Party patient, Party location, Context context, HelpContext help) {
        super(help);
        this.patient = patient;
        this.location = location;
        this.context = context;
    }

    @Override
    protected void doLayout() {
        super.doLayout();
        String uri = this.rules.getURL(this.patient);
        MonitoredFrame frame = new MonitoredFrame(uri);
        frame.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                VetCheckDialog.this.addLink(event.getActionCommand());
            }
        });
        this.getLayout().add((Component)frame);
    }

    private void addLink(String data) {
        MutableObject holder = new MutableObject();
        Retryable action = () -> {
            VetCheckLink link = this.rules.addLink(this.patient, this.location, UserHelper.getClinician((Context)this.context), data);
            holder.setValue((Object)link);
            return true;
        };
        if (Retryer.run((Retryable)action)) {
            VetCheckLink link = (VetCheckLink)holder.getValue();
            if (link != null) {
                log.info("Added link for patient id={}, name={}, link={}", new Object[]{this.patient.getId(), this.patient.getName(), link.getUrl()});
                InformationDialog dialog = ((InformationDialogBuilder)((InformationDialogBuilder)((InformationDialogBuilder)((InformationDialogBuilder)InformationDialog.newDialog().message(Messages.format((String)"vetcheckdialog.link.success", (Object[])new Object[]{link.getDescription()}))).style("InformationMessage")).sizeToContent()).position(10, 10)).build();
                this.getContentPane().add((Component)dialog);
                dialog.show(3);
            } else {
                log.info("Failed to add link for patient id={}, name={}. Link not recognised: {}", new Object[]{this.patient.getId(), this.patient.getName(), data});
                ((ErrorDialogBuilder)((ErrorDialogBuilder)ErrorDialog.newDialog().title(Messages.get((String)"vetcheckdialog.title"))).message(Messages.get((String)"vetcheckdialog.link.error"))).show();
            }
        } else {
            log.error("Failed to add link for patient id={}, name={}, shareLink={}", new Object[]{this.patient.getId(), this.patient.getName(), data});
        }
    }
}

