/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.summary;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.layout.GridLayoutData;
import nextapp.echo2.app.layout.RowLayoutData;
import nextapp.echo2.app.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.rules.supplier.SupplierRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.alert.Alert;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextApplicationInstance;
import org.openvpms.web.component.app.ContextHelper;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.app.GlobalContext;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditDialogFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ActResultSet;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.table.act.AbstractActTableModel;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;
import org.openvpms.web.component.im.view.IMObjectViewerDialog;
import org.openvpms.web.component.im.view.TableComponentFactory;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.alert.AlertSummary;
import org.openvpms.web.workspace.customer.CustomerMailContext;
import org.openvpms.web.workspace.customer.estimate.CustomerEstimates;
import org.openvpms.web.workspace.customer.estimate.EstimateViewer;
import org.openvpms.web.workspace.patient.PatientIdentityEditor;
import org.openvpms.web.workspace.patient.summary.PatientCageEditor;
import org.openvpms.web.workspace.patient.summary.ReminderTableCellRenderer;
import org.openvpms.web.workspace.patient.vetcheck.VetCheckSummary;
import org.openvpms.web.workspace.summary.PartySummary;
import org.openvpms.web.workspace.workflow.worklist.FollowUpTaskEditor;

public class PatientSummary
extends PartySummary {
    private final ContextSwitchListener listener;
    private final PatientRules rules;
    private final ReminderRules reminderRules;
    private final InsuranceRules insuranceRules;
    private static final String ALWAYS_SHOW_REFERRAL = "ALWAYS";
    private static final String SHOW_ACTIVE_REFERRAL = "ACTIVE";
    private static final String NEVER_SHOW_REFERRAL = "NEVER";
    private static final int MAX_CAGE_LENGTH = 12;

    public PatientSummary(Context context, HelpContext help, Preferences preferences, ContextSwitchListener listener) {
        super(context, help.topic("patient/summary"), preferences);
        this.listener = listener;
        this.rules = (PatientRules)ServiceHelper.getBean(PatientRules.class);
        this.reminderRules = (ReminderRules)ServiceHelper.getBean(ReminderRules.class);
        this.insuranceRules = (InsuranceRules)ServiceHelper.getBean(InsuranceRules.class);
    }

    @Override
    protected Component createSummary(Party patient, List<Alert> alerts) {
        Column column = ColumnFactory.create();
        List<Component> components = this.getSummaryComponents(patient);
        for (Component component : components) {
            if (!(component instanceof Grid)) {
                column.add((Component)ColumnFactory.create((String)"Inset.Small", (Component[])new Component[]{component}));
                continue;
            }
            column.add(component);
        }
        if (!alerts.isEmpty()) {
            AlertSummary alertSummary = new AlertSummary(patient, alerts, this.getContext(), this.getHelpContext());
            column.add((Component)ColumnFactory.create((String)"Inset.Small", (Component[])new Component[]{alertSummary.getComponent()}));
        }
        this.addVetCheck(patient, (Component)column);
        return ColumnFactory.create((String)"PartySummary", (Component[])new Component[]{column});
    }

    protected List<Component> getSummaryComponents(Party patient) {
        ArrayList<Component> result = new ArrayList<Component>();
        result.add(this.getPatientName(patient));
        result.add(this.getPatientId(patient));
        if (this.rules.isDeceased(patient)) {
            result.add(this.getDeceased());
        }
        result.add(this.getSpecies(patient));
        result.add(this.getBreed(patient));
        result.add((Component)this.createSummaryGrid(patient));
        return result;
    }

    protected Component getPatientName(Party patient) {
        String name = patient.getName();
        name = this.rules.isDesexed(patient) ? name + " (" + this.getPatientSex(patient) + " " + Messages.get((String)"patient.desexed") + ")" : name + " (" + this.getPatientSex(patient) + " " + Messages.get((String)"patient.entire") + ")";
        IMObjectReferenceViewer patientName = new IMObjectReferenceViewer(patient.getObjectReference(), name, this.listener, this.getContext());
        patientName.setStyleName("hyperlink-bold");
        return patientName.getComponent();
    }

    protected Component getPatientId(Party patient) {
        Label patientId = this.createLabel("patient.id", patient.getId());
        Button followup = ButtonFactory.create(null, (String)"button.followup", this::onFollowUp);
        followup.setToolTipText(Messages.get((String)"patient.followup.icon"));
        Row right = RowFactory.create((Component[])new Component[]{followup});
        RowLayoutData rightLayout = new RowLayoutData();
        rightLayout.setAlignment(Alignment.ALIGN_RIGHT);
        rightLayout.setWidth(Styles.FULL_WIDTH);
        right.setLayoutData((LayoutData)rightLayout);
        return RowFactory.create((String)"WideCellSpacing", (Component[])new Component[]{patientId, right});
    }

    protected Component getDeceased() {
        return LabelFactory.create((String)"patient.deceased", (String)"Patient.Deceased");
    }

    protected Component getSpecies(Party patient) {
        return LabelFactory.text((String)this.getPatientSpecies(patient));
    }

    protected Component getBreed(Party patient) {
        return LabelFactory.text((String)this.getPatientBreed(patient));
    }

    protected Grid createSummaryGrid(Party patient) {
        Grid grid = GridFactory.create((int)2);
        this.addColour(patient, grid);
        this.addPopupButtons(patient, grid);
        this.addAge(patient, grid);
        this.addDateOfBirth(patient, grid);
        this.addWeight(patient, grid);
        this.addMicrochip(patient, grid);
        this.addInsurancePolicy(patient, grid);
        this.addCage(patient, grid);
        this.addReferral(patient, grid);
        return grid;
    }

    protected void addPopupButtons(Party patient, Grid grid) {
        Label component;
        Label label = LabelFactory.create((String)"patient.reminders");
        Button reminders = this.getReminderButton(patient);
        Button estimates = this.getEstimateButton(patient);
        if (reminders == null && estimates == null) {
            component = LabelFactory.create((String)"patient.noreminders");
        } else {
            component = RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
            if (reminders != null) {
                component.add((Component)reminders);
            }
            if (estimates != null) {
                component.add((Component)estimates);
            }
        }
        grid.add((Component)label);
        grid.add((Component)component);
    }

    protected Button getReminderButton(Party patient) {
        Button result = null;
        ReminderRules.DueState due = this.getDueState(patient);
        if (due != null) {
            String style = "reminder." + due;
            result = ButtonFactory.create(null, (String)style, () -> this.onShowReminders(patient));
        }
        return result;
    }

    protected Button getEstimateButton(Party patient) {
        Button result = null;
        if (this.hasEstimates(patient)) {
            result = ButtonFactory.create(null, (String)"estimate.available", () -> this.onShowEstimates(patient));
        }
        return result;
    }

    protected void addColour(Party patient, Grid grid) {
        String colour = this.rules.getPatientColour(patient);
        if (colour != null) {
            grid.add((Component)LabelFactory.create((String)"patient.colour"));
            grid.add((Component)LabelFactory.text((String)colour));
        }
    }

    protected void addAge(Party patient, Grid grid) {
        Label ageTitle = LabelFactory.create((String)"patient.age");
        Label age = LabelFactory.text((String)this.rules.getPatientAge(patient));
        grid.add((Component)ageTitle);
        grid.add((Component)age);
    }

    protected void addDateOfBirth(Party patient, Grid grid) {
        Label title = LabelFactory.create((String)"patient.dateOfBirth");
        Label text = LabelFactory.create();
        Date dateOfBirth = this.rules.getDateOfBirth(patient);
        if (dateOfBirth != null) {
            text.setText(DateFormatter.formatDate((Date)dateOfBirth, (boolean)false));
        }
        grid.add((Component)title);
        grid.add((Component)text);
    }

    protected void addWeight(Party patient, Grid grid) {
        Label weightTitle = LabelFactory.create((String)"patient.weight");
        Label weight = LabelFactory.text((String)this.getPatientWeight(patient));
        grid.add((Component)weightTitle);
        grid.add((Component)weight);
    }

    protected void addMicrochip(Party patient, Grid grid) {
        Label title = LabelFactory.create((String)"patient.microchip");
        Row container = new Row();
        grid.add((Component)title);
        grid.add((Component)container);
        this.refreshMicrochip(patient, (Component)container);
    }

    protected void refreshMicrochip(Party patient, Component container) {
        container.removeAll();
        String identity = this.rules.getMicrochipNumber(patient);
        if (identity != null) {
            Label microchip = LabelFactory.text((String)identity);
            container.add((Component)microchip);
        } else {
            Button add = ButtonFactory.create((String)"button.add", (String)"default", (boolean)false, () -> this.onCreateMicrochip(patient, container));
            container.add((Component)add);
        }
    }

    protected void addInsurancePolicy(Party patient, Grid grid) {
        Party insurer;
        Date endTime;
        Act policy;
        Label title = LabelFactory.create((String)"patient.insurance");
        Party customer = this.getContext().getCustomer();
        Act act = policy = customer != null ? this.insuranceRules.getPolicy(customer, patient) : null;
        String name = policy == null ? Messages.get((String)"patient.insurance.none") : ((endTime = policy.getActivityEndTime()) != null && endTime.compareTo(new Date()) < 0 ? Messages.get((String)"patient.insurance.expired") : ((insurer = this.insuranceRules.getInsurer(policy)) != null ? insurer.getName() : Messages.get((String)"patient.insurance.none")));
        grid.add((Component)title);
        if (this.listener != null) {
            Button button = ButtonFactory.create(null, (String)"hyperlink-bold", () -> {
                ContextApplicationInstance instance = ContextApplicationInstance.getInstance();
                ContextHelper.setPatient((Context)instance.getContext(), (Party)patient, (boolean)false);
                this.listener.switchTo("act.patientInsurancePolicy");
            });
            button.setText(name);
            grid.add((Component)button);
        } else {
            Label label = LabelFactory.create(null, (String)"bold");
            label.setText(name);
            grid.add((Component)label);
        }
    }

    protected void addCage(Party patient, Grid grid) {
        if (this.getPreferences().getBoolean("entity.preferenceGroupSummary", "showCage", false)) {
            Label title = LabelFactory.create((String)"patient.cage");
            Row container = new Row();
            grid.add((Component)title);
            grid.add((Component)container);
            this.refreshCage(patient, (Component)container);
        }
    }

    protected void refreshCage(Party patient, Component container) {
        container.removeAll();
        String cage = this.rules.getCage(patient);
        if (cage == null) {
            cage = Messages.format((String)"imobject.none", (Object[])new Object[0]);
        }
        Button button = ButtonFactory.create(() -> {
            PatientCageEditor editor = new PatientCageEditor();
            editor.edit(patient, this.getContext(), this.getHelpContext(), party -> {
                this.refreshCage((Party)party, container);
                this.updateGlobalContext((Party)party);
            });
        });
        if (cage.length() > 12) {
            button.setToolTipText(cage);
            cage = StringUtils.abbreviate((String)cage, (int)12);
        }
        button.setText(cage);
        container.add((Component)button);
    }

    protected void addReferral(Party patient, Grid grid) {
        Party vet;
        String showReferral = this.getPreferences().getString("entity.preferenceGroupSummary", "showReferral", NEVER_SHOW_REFERRAL);
        if (!NEVER_SHOW_REFERRAL.equals(showReferral) && ((vet = this.rules.getReferralVet(patient, new Date(), false)) != null || ALWAYS_SHOW_REFERRAL.equals(showReferral))) {
            grid.add((Component)LabelFactory.create((String)"patient.referralvet"));
            if (vet != null) {
                grid.add((Component)new Label());
                Component referralVet = this.getReferralVet(vet);
                GridLayoutData layout = ComponentGrid.layout((int)1, (int)2);
                grid.add((Component)RowFactory.create((String)"InsetX", (LayoutData)layout, (Component[])new Component[]{referralVet}));
                Component referralPractice = this.getReferralPractice(vet);
                if (referralPractice != null) {
                    Row row = RowFactory.create((String)"InsetX", (LayoutData)layout, (Component[])new Component[]{referralPractice});
                    grid.add((Component)row);
                }
            } else {
                grid.add((Component)LabelFactory.create((String)"imobject.none"));
            }
        }
    }

    protected Component getReferralVet(Party vet) {
        Button name = ButtonFactory.create(null, (String)"hyperlink-bold", () -> this.onShowReferralVet(vet));
        name.setText(vet.getName());
        Object result = !vet.isActive() ? RowFactory.create((String)"CellSpacing", (Component[])new Component[]{name, LabelFactory.create((String)"imobject.inactive")}) : name;
        return result;
    }

    protected Component getReferralPractice(Party vet) {
        Object result = null;
        SupplierRules bean = (SupplierRules)ServiceHelper.getBean(SupplierRules.class);
        Party practice = bean.getReferralVetPractice(vet, new Date(), false);
        if (practice != null) {
            Button button = ButtonFactory.create(null, (String)"hyperlink-bold", () -> this.onShowReferralVet(practice));
            button.setText(practice.getName());
            result = !practice.isActive() ? RowFactory.create((String)"CellSpacing", (Component[])new Component[]{button, LabelFactory.create((String)"imobject.inactive")}) : button;
        }
        return result;
    }

    protected void onFollowUp() {
        Act act = (Act)IMObjectCreator.create((String)"act.customerTask");
        DefaultLayoutContext context = new DefaultLayoutContext(this.getContext(), this.getHelpContext().topic((IMObject)act, "edit"));
        List<Entity> workLists = FollowUpTaskEditor.getWorkLists(this.getContext());
        if (workLists.isEmpty()) {
            InformationDialog.show((String)Messages.get((String)"patient.followup.noworklists"));
        } else {
            FollowUpTaskEditor editor = new FollowUpTaskEditor(act, workLists, (LayoutContext)context);
            EditDialog dialog = ((EditDialogFactory)ServiceHelper.getBean(EditDialogFactory.class)).create((IMObjectEditor)editor, this.getContext());
            dialog.show();
        }
    }

    protected void onCreateMicrochip(Party patient, final Component container) {
        final PatientIdentityEditor editor = PatientIdentityEditor.create(patient, "entityIdentity.microchip", this.getContext(), this.getHelpContext());
        if (editor != null) {
            EditDialog dialog = editor.edit(false);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    Party latest = editor.getPatient();
                    PatientSummary.this.refreshMicrochip(latest, container);
                    PatientSummary.this.updateGlobalContext(latest);
                }
            });
            dialog.show();
        }
    }

    protected ReminderRules.DueState getDueState(Party patient) {
        ActResultSet<Act> reminders = this.createActResultSet(patient, 20, "act.patientReminder");
        ResultSetIterator iterator = new ResultSetIterator(reminders);
        ReminderRules.DueState result = null;
        while (iterator.hasNext()) {
            ReminderRules.DueState due = this.getDueState((Act)iterator.next());
            if (result == null || due.compareTo((Enum)result) > 0) {
                result = due;
            }
            if (result != ReminderRules.DueState.OVERDUE) continue;
            break;
        }
        return result;
    }

    protected ReminderRules.DueState getDueState(Act reminder) {
        return this.reminderRules.getDueState(reminder);
    }

    protected void onShowReminders(Party patient) {
        PagedIMTable table = new PagedIMTable((IMTableModel)new ReminderTableModel(this.getContext(), this.getHelpContext()), this.getReminders(patient));
        table.getTable().setDefaultRenderer(Object.class, (TableCellRenderer)new ReminderTableCellRenderer());
        new ViewerDialog(Messages.get((String)"patient.summary.reminders"), "PatientSummary.ReminderDialog", (PagedIMTable<Act>)table);
    }

    protected ResultSet<Act> getReminders(Party patient) {
        String[] shortNames = new String[]{"act.patientReminder"};
        String[] statuses = new String[]{"IN_PROGRESS"};
        ShortNameConstraint archetypes = new ShortNameConstraint(shortNames, true, true);
        ParticipantConstraint[] participants = new ParticipantConstraint[]{new ParticipantConstraint("patient", "participation.patient", (Entity)patient)};
        SortConstraint[] sort = new SortConstraint[]{new NodeSortConstraint("endTime", true)};
        return new ActResultSet(archetypes, participants, null, statuses, false, null, 10, sort);
    }

    private ActResultSet<Act> createActResultSet(Party patient, int pageSize, String ... shortNames) {
        String[] statuses = new String[]{"IN_PROGRESS"};
        ShortNameConstraint archetypes = new ShortNameConstraint(shortNames, true, true);
        ParticipantConstraint[] participants = new ParticipantConstraint[]{new ParticipantConstraint("patient", "participation.patient", (Entity)patient)};
        return new ActResultSet(archetypes, participants, null, statuses, false, null, pageSize, null);
    }

    private void onShowEstimates(Party patient) {
        CustomerEstimates query;
        List<Act> estimates;
        Party customer = this.rules.getOwner(patient);
        if (customer != null && !(estimates = (query = new CustomerEstimates()).getEstimates(customer, patient)).isEmpty()) {
            EstimateViewer viewer = new EstimateViewer(estimates, this.getContext(), this.getHelpContext());
            viewer.show();
        }
    }

    private void onShowReferralVet(Party vet) {
        Context context = this.getContext();
        HelpContext help = this.getHelpContext();
        CustomerMailContext mailContext = new CustomerMailContext(context, help);
        IMObjectViewerDialog dialog = new IMObjectViewerDialog((IMObject)vet, PopupDialog.OK, context, (MailContext)mailContext, help);
        dialog.setStyleName("PatientSummary.ReferralDialog");
        dialog.show();
    }

    private String getPatientSpecies(Party patient) {
        return this.rules.getPatientSpecies(patient);
    }

    private String getPatientBreed(Party patient) {
        return this.rules.getPatientBreed(patient);
    }

    private String getPatientSex(Party patient) {
        return this.rules.getPatientSex(patient);
    }

    private String getPatientWeight(Party patient) {
        String weight = this.rules.getPatientWeight(patient);
        return weight != null ? weight : Messages.get((String)"patient.noweight");
    }

    private boolean hasEstimates(Party patient) {
        Party customer = this.rules.getOwner(patient);
        if (customer != null) {
            CustomerEstimates query = new CustomerEstimates();
            return query.hasEstimates(customer, patient);
        }
        return false;
    }

    private static LayoutContext createLayoutContext(Context context, HelpContext help) {
        DefaultLayoutContext result = new DefaultLayoutContext(context, help);
        result.setEdit(true);
        TableComponentFactory factory = new TableComponentFactory((LayoutContext)result);
        result.setComponentFactory((IMObjectComponentFactory)factory);
        return result;
    }

    private void addVetCheck(Party patient, Component container) {
        Component summary = VetCheckSummary.getSummary(patient, this.getContext(), this.getHelpContext());
        if (summary != null) {
            container.add((Component)ColumnFactory.create((String)"Inset.Small", (Component[])new Component[]{summary}));
        }
    }

    private void updateGlobalContext(Party patient) {
        GlobalContext globalContext = ContextApplicationInstance.getInstance().getContext();
        if (Objects.equals(patient, globalContext.getPatient())) {
            globalContext.setPatient(patient);
        }
    }

    protected static class ReminderTableModel
    extends AbstractActTableModel {
        public ReminderTableModel(Context context, HelpContext help) {
            super(new String[]{"act.patientReminder"}, PatientSummary.createLayoutContext(context, help));
        }

        protected String[] getNodeNames() {
            return new String[]{"reminderType", "endTime", "product"};
        }
    }

    protected static class ViewerDialog
    extends PopupDialog {
        public ViewerDialog(String title, String style, PagedIMTable<Act> table) {
            super(title, style, OK);
            this.setModal(true);
            this.getLayout().add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{table.getComponent()}));
            this.show();
        }
    }
}

