/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.problem;

import java.util.Date;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.button.ButtonGroup;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.print.IMObjectReportPrinter;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.util.LookupNameHelper;
import org.openvpms.web.component.print.Printer;
import org.openvpms.web.component.retry.Retryable;
import org.openvpms.web.component.retry.Retryer;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.PatientMedicalRecordLinker;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryCRUDWindow;
import org.openvpms.web.workspace.patient.history.PatientHistoryActions;
import org.openvpms.web.workspace.patient.history.TextSearch;
import org.openvpms.web.workspace.patient.problem.ProblemFilter;
import org.openvpms.web.workspace.patient.problem.ProblemHierarchyIterator;
import org.openvpms.web.workspace.patient.problem.ProblemQuery;

public class ProblemRecordCRUDWindow
extends AbstractPatientHistoryCRUDWindow {
    private Act problem;
    private ProblemQuery query;

    public ProblemRecordCRUDWindow(Context context, HelpContext help) {
        super((Archetypes<Act>)Archetypes.create((String)"act.patientClinicalProblem", Act.class, (String)Messages.get((String)"patient.record.createtype")), ProblemActions.INSTANCE, context, help);
    }

    public void setObject(Act object) {
        super.setObject((IMObject)object);
        if (object != null) {
            if (TypeHelper.isA((IMObject)object, (String)"act.patientClinicalProblem")) {
                this.setProblem(object);
            } else if (TypeHelper.isA((IMObject)object, (String)"act.patientClinicalEvent")) {
                this.setProblem(null);
            } else {
                this.setProblem(this.getSource(object, "act.patientClinicalProblem"));
            }
        }
    }

    public void setProblem(Act problem) {
        this.problem = problem;
    }

    public Act getProblem() {
        return this.problem;
    }

    public void setQuery(ProblemQuery query) {
        this.query = query;
    }

    @Override
    protected ProblemActions getActions() {
        return (ProblemActions)super.getActions();
    }

    protected void onPrint() {
        if (this.query != null) {
            Context context = this.getContext();
            IMObjectReportPrinter<Act> printer = this.createPrinter(context);
            String title = Messages.get((String)"patient.record.problem.print");
            HelpContext help = this.getHelpContext().topic("act.patientClinicalProblem/print");
            InteractiveIMPrinter iPrinter = new InteractiveIMPrinter(title, printer, context, help);
            iPrinter.setMailContext(this.getMailContext());
            iPrinter.print();
        }
    }

    protected void onPreview() {
        if (this.query != null) {
            Context context = this.getContext();
            IMObjectReportPrinter<Act> printer = this.createPrinter(context);
            this.preview((Printer)printer);
        }
    }

    protected void onMail() {
        if (this.query != null) {
            Context context = this.getContext();
            IMObjectReportPrinter<Act> printer = this.createPrinter(context);
            this.mail((IMPrinter)printer);
        }
    }

    @Override
    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(this.createMarkReviewedButton());
        buttons.add(this.createUnmarkReviewedButton());
        buttons.add(this.createExternalEditButton());
    }

    @Override
    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        this.enablePrintPreview(buttons, enable);
    }

    protected void onCreate(Archetypes<Act> archetypes) {
        if (this.problem != null) {
            boolean includeAddendum = false;
            String defaultShortName = "act.patientClinicalNote";
            Act selected = (Act)this.getObject();
            if (TypeHelper.isA((IMObject)selected, (String[])new String[]{"act.patientClinicalNote", "act.patientMedication"})) {
                includeAddendum = true;
                if (this.getActions().isLocked(selected)) {
                    defaultShortName = "act.patientClinicalAddendum";
                }
            }
            String[] shortNames = this.getShortNames("actRelationship.patientClinicalProblemItem", includeAddendum, "act.patientClinicalProblem");
            archetypes = new Archetypes(shortNames, archetypes.getType(), defaultShortName, archetypes.getDisplayName());
        }
        super.onCreate(archetypes);
    }

    @Override
    protected void onCreated(final Act object) {
        if (object.isA("act.patientClinicalProblem")) {
            final Act event = this.getLatestEvent(this.getContext().getPatient());
            if (event != null) {
                final VisitSelectionDialog dialog = new VisitSelectionDialog(event, this.getHelpContext());
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onOK() {
                        if (dialog.createVisit()) {
                            ProblemRecordCRUDWindow.this.createEvent();
                        } else {
                            ProblemRecordCRUDWindow.this.setEvent(event);
                        }
                        ProblemRecordCRUDWindow.super.onCreated(object);
                    }
                });
                dialog.show();
            } else {
                ConfirmationDialog dialog = new ConfirmationDialog(Messages.get((String)"patient.record.problem.createVisit.title"), Messages.get((String)"patient.record.problem.createVisit.message"));
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onOK() {
                        ProblemRecordCRUDWindow.this.createEvent();
                        ProblemRecordCRUDWindow.super.onCreated(object);
                    }
                });
                dialog.show();
            }
        } else {
            super.onCreated(object);
        }
    }

    protected EditDialog createEditDialog(IMObjectEditor editor) {
        EditDialog dialog = super.createEditDialog(editor);
        dialog.setPostSaveCallback(e -> this.linkRecords((Act)e.getObject()));
        return dialog;
    }

    protected void linkRecords(Act act) {
        if (!act.isA("act.patientClinicalEvent")) {
            Act problem;
            if (!act.isA("act.patientClinicalProblem")) {
                problem = this.getProblem(act);
            } else {
                problem = act;
                act = null;
            }
            Act event = this.getEvent();
            Act selected = (Act)this.getObject();
            PatientMedicalRecordLinker linker = TypeHelper.isA((IMObject)act, (String)"act.patientClinicalAddendum") ? (!TypeHelper.isA((IMObject)selected, (String)"act.patientClinicalAddendum") ? this.createMedicalRecordLinker(event, problem, selected, act) : this.createMedicalRecordLinker(event, problem, null, act)) : this.createMedicalRecordLinker(event, problem, act, null);
            Retryer.run((Retryable)linker);
        }
    }

    protected void onDeleted(Act object) {
        if (TypeHelper.isA((IMObject)object, (String)"act.patientClinicalProblem")) {
            this.setProblem(null);
        }
        super.onDeleted((IMObject)object);
    }

    private IMObjectReportPrinter<Act> createPrinter(Context context) {
        TextSearch search = null;
        String value = this.query.getValue();
        Preferences preferences = ServiceHelper.getPreferences();
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        if (!StringUtils.isEmpty((CharSequence)value)) {
            boolean showClinician = preferences.getBoolean("entity.preferenceGroupHistory", "showClinician", false);
            boolean showBatches = preferences.getBoolean("entity.preferenceGroupHistory", "showBatches", false);
            search = new TextSearch(value, showClinician, showBatches, (IArchetypeService)service);
        }
        ProblemFilter filter = new ProblemFilter(this.query.getSelectedArchetypes(), search, this.query.isSortAscending(), (ArchetypeService)service);
        ProblemHierarchyIterator summary = new ProblemHierarchyIterator((Iterable<Act>)((Object)this.query), filter);
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator("act.patientClinicalProblem", context);
        IMPrinterFactory factory = (IMPrinterFactory)ServiceHelper.getBean(IMPrinterFactory.class);
        return factory.createIMObjectReportPrinter((Iterable)((Object)summary), (DocumentTemplateLocator)locator, context);
    }

    private Act getLatestEvent(Party patient) {
        ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)Constraints.shortName((String)"e", (String)"act.patientClinicalEvent"));
        query.add((IConstraint)Constraints.join((String)"patient").add((IConstraint)Constraints.eq((String)"entity", (Object)patient)));
        query.add((IConstraint)Constraints.sort((String)"startTime", (boolean)false));
        query.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator((IArchetypeQuery)query);
        return iterator.hasNext() ? (Act)iterator.next() : null;
    }

    private Act getProblem(Act act) {
        Act result = this.getSource(act, "act.patientClinicalProblem");
        return result != null ? result : this.problem;
    }

    private Act getSource(Act act, String shortName) {
        for (Relationship relationship : act.getTargetActRelationships()) {
            Reference source = relationship.getSource();
            if (!source.isA(shortName)) continue;
            return (Act)IMObjectHelper.getObject((Reference)source, (Context)this.getContext());
        }
        return null;
    }

    private static class VisitSelectionDialog
    extends PopupDialog {
        private final RadioButton newVisit;

        public VisitSelectionDialog(Act event, HelpContext help) {
            super(Messages.get((String)"patient.record.problem.selectVisit.title"), OK_CANCEL, help.subtopic("selectVisit"));
            this.setModal(true);
            ButtonGroup group = new ButtonGroup();
            Runnable listener = () -> {};
            RadioButton existingVisit = ButtonFactory.create(null, (ButtonGroup)group, (Runnable)listener);
            existingVisit.setText(this.getEventDescription(event));
            existingVisit.setSelected(true);
            this.newVisit = ButtonFactory.create((String)"patient.record.problem.selectVisit.new", (ButtonGroup)group, (Runnable)listener);
            existingVisit.setGroup(group);
            this.newVisit.setGroup(group);
            Label label = LabelFactory.create((String)"patient.record.problem.selectVisit.message");
            Column column = ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{label, existingVisit, this.newVisit});
            this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column}));
        }

        public boolean createVisit() {
            return this.newVisit.isSelected();
        }

        private String getEventDescription(Act act) {
            String title = act.getTitle();
            String reason = LookupNameHelper.getName((IMObject)act, (String)"reason");
            String date = DateFormatter.formatDate((Date)act.getActivityStartTime(), (boolean)false);
            String result = !StringUtils.isEmpty((CharSequence)reason) && !StringUtils.isEmpty((CharSequence)title) ? Messages.format((String)"patient.record.problem.selectVisit.datedReasonAndSummary", (Object[])new Object[]{date, reason, title}) : (!StringUtils.isEmpty((CharSequence)reason) ? Messages.format((String)"patient.record.problem.selectVisit.datedReason", (Object[])new Object[]{date, reason}) : (!StringUtils.isEmpty((CharSequence)title) ? Messages.format((String)"patient.record.problem.selectVisit.datedReason", (Object[])new Object[]{date, title}) : date));
            return result;
        }
    }

    private static class ProblemActions
    extends PatientHistoryActions {
        public static final ProblemActions INSTANCE = new ProblemActions();

        private ProblemActions() {
        }

        @Override
        public boolean canDelete(Act act) {
            return !TypeHelper.isA((IMObject)act, (String)"act.patientClinicalEvent") && super.canDelete(act);
        }
    }
}

