/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openvpms.archetype.rules.patient.prescription.PrescriptionRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.workspace.patient.mr.Prescription;

public class Prescriptions {
    private final Map<Reference, Prescription> prescriptions = new HashMap<Reference, Prescription>();
    private final Map<Reference, Act> medications = new HashMap<Reference, Act>();
    private final PrescriptionRules rules;
    private final ArchetypeService service;

    public Prescriptions(List<Act> items, PrescriptionRules rules, ArchetypeService service) {
        this.rules = rules;
        this.service = service;
        for (Act item : items) {
            IMObjectBean bean = service.getBean((IMObject)item);
            for (Act medication : bean.getTargets("dispensing", Act.class)) {
                IMObjectBean medBean = service.getBean((IMObject)medication);
                Reference product = medBean.getTargetRef("product");
                Act prescription = (Act)medBean.getSource("prescription", Act.class);
                if (product == null || prescription == null) continue;
                this.prescriptions.put(prescription.getObjectReference(), new Prescription(prescription, rules, this));
                this.medications.put(medication.getObjectReference(), medication);
            }
        }
    }

    public void removeItem(Act item) {
        Act medication = this.getMedication(item);
        if (medication != null) {
            this.medications.remove(medication.getObjectReference());
            Prescription prescription = this.getMedicationPrescription(medication);
            if (prescription != null) {
                prescription.removeMedication(medication);
            }
        }
    }

    public Act getPrescription(Party patient, Product product) {
        Act act;
        Prescription result = null;
        Reference productRef = product.getObjectReference();
        Reference patientRef = patient.getObjectReference();
        ArrayList<Act> exclude = new ArrayList<Act>();
        for (Prescription prescription : this.prescriptions.values()) {
            if (!Objects.equals(patientRef, prescription.getPatient()) || !Objects.equals(productRef, prescription.getProduct())) continue;
            if (prescription.canDispense()) {
                result = prescription;
                break;
            }
            exclude.add(prescription.getAct());
        }
        if (result == null && (act = this.rules.getPrescription(patient, product, exclude)) != null) {
            result = new Prescription(act, this.rules, this);
            this.prescriptions.put(act.getObjectReference(), result);
        }
        return result != null ? result.getAct() : null;
    }

    public void add(Act act) {
        this.prescriptions.put(act.getObjectReference(), new Prescription(act, this.rules, this));
    }

    public void addMedication(Act medication) {
        this.medications.put(medication.getObjectReference(), medication);
    }

    public Prescription create(Act act) {
        Prescription result = this.prescriptions.get(act.getObjectReference());
        if (result == null) {
            result = new Prescription(act, this.rules, this);
            this.prescriptions.put(act.getObjectReference(), result);
        }
        return result;
    }

    public boolean save() {
        for (Prescription prescription : this.prescriptions.values()) {
            if (prescription.save()) continue;
            return false;
        }
        return true;
    }

    public void removeMedication(Act medication) {
        Prescription prescription = this.getPrescriptionForMedication(medication);
        if (prescription != null) {
            prescription.removeMedication(medication);
        }
    }

    private Prescription getMedicationPrescription(Act medication) {
        Prescription result = null;
        ActRelationship relationship = this.getPrescriptionRelationship(medication);
        if (relationship != null) {
            result = this.prescriptions.get(relationship.getSource());
        }
        return result;
    }

    private Act getMedication(Act item) {
        IMObjectBean bean = this.service.getBean((IMObject)item);
        List refs = bean.getTargetRefs("dispensing");
        if (!refs.isEmpty()) {
            return this.medications.get(refs.get(0));
        }
        return null;
    }

    private ActRelationship getPrescriptionRelationship(Act medication) {
        IMObjectBean bean = this.service.getBean((IMObject)medication);
        return (ActRelationship)bean.getObject("prescription", ActRelationship.class);
    }

    private Prescription getPrescriptionForMedication(Act medication) {
        Prescription result = null;
        ActRelationship relationship = this.getPrescriptionRelationship(medication);
        if (relationship != null) {
            Act act;
            Prescription prescription = this.prescriptions.get(relationship.getSource());
            if (prescription != null) {
                result = prescription;
            }
            if (result == null && relationship.getSource() != null && (act = (Act)this.service.get(relationship.getSource(), Act.class)) != null) {
                result = new Prescription(act, this.rules, this);
                this.prescriptions.put(act.getObjectReference(), result);
            }
        }
        return result;
    }
}

