/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.math.BigDecimal;
import org.openvpms.archetype.rules.patient.prescription.PrescriptionRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.mr.Prescriptions;

public class Prescription {
    private final Act prescription;
    private final IMObjectBean bean;
    private final Reference patient;
    private final Reference product;
    private final PrescriptionRules rules;
    private final Prescriptions prescriptions;

    public Prescription(Act prescription, PrescriptionRules rules, Prescriptions prescriptions) {
        this.prescription = prescription;
        this.bean = ServiceHelper.getArchetypeService().getBean((IMObject)prescription);
        this.rules = rules;
        this.prescriptions = prescriptions;
        this.patient = this.bean.getTargetRef("patient");
        this.product = this.bean.getTargetRef("product");
    }

    public boolean save() {
        return SaveHelper.save((IMObject)this.bean.getObject());
    }

    public Reference getPatient() {
        return this.patient;
    }

    public Reference getProduct() {
        return this.product;
    }

    public String getLabel() {
        return this.bean.getString("label");
    }

    public void addMedication(Act medication) {
        this.bean.addTarget("dispensing", (IMObject)medication, "prescription");
        this.prescriptions.addMedication(medication);
    }

    public void removeMedication(Act medication) {
        ActRelationship relationship = (ActRelationship)this.bean.getValue("dispensing", ActRelationship.class, Predicates.targetEquals((IMObject)medication));
        if (relationship != null) {
            medication.removeActRelationship(relationship);
            this.prescription.removeActRelationship(relationship);
        }
    }

    public Act getAct() {
        return this.prescription;
    }

    public boolean canDispense() {
        return this.rules.canDispense(this.prescription);
    }

    public BigDecimal getQuantity() {
        return this.rules.getQuantity(this.prescription);
    }
}

