/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.util.List;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.patient.prescription.PrescriptionRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditDialogFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.layout.PrintObjectLayoutStrategy;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.ReadOnlyComponentFactory;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.ReadOnlyProperty;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.echo.text.TextArea;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.mr.Prescriptions;

public class PatientMedicationActLayoutStrategy
extends PrintObjectLayoutStrategy {
    private boolean showProduct;
    private boolean showProductReadOnly;
    private boolean prescription = false;
    private Prescriptions prescriptions;
    private Button newPrescription;
    private ReadOnlyComponentFactory factory;
    static final String PRODUCT = "product";
    static final String QUANTITY = "quantity";
    static final String LABEL = "label";

    public PatientMedicationActLayoutStrategy() {
        super("button.printlabel");
    }

    public void setProductReadOnly(boolean readOnly) {
        this.showProduct = true;
        this.showProductReadOnly = readOnly;
    }

    public void setDispensedFromPrescription(boolean prescription) {
        this.prescription = prescription;
    }

    public void setPrescriptions(Prescriptions prescriptions) {
        this.prescriptions = prescriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        ComponentState result;
        this.newPrescription = ButtonFactory.create((String)"button.newprescription", () -> this.onNewPrescription((Act)object, context));
        try {
            boolean show = this.showProduct;
            if (!this.showProductReadOnly) {
                IMObjectBean bean;
                show = parent instanceof Act ? !(bean = this.getBean(parent)).hasNode(PRODUCT) : true;
            } else {
                this.addComponent(this.getReadOnlyComponent(properties.get(PRODUCT), parent, context));
            }
            Property label = properties.get(LABEL);
            if (this.prescription) {
                this.addComponent(this.getReadOnlyComponent(properties.get(QUANTITY), parent, context));
                label = new ReadOnlyProperty(label);
            }
            this.addComponent(this.createNotes(parent, label, context));
            ArchetypeNodes nodes = new ArchetypeNodes().exclude(new String[]{LABEL});
            if (!show) {
                nodes.exclude(new String[]{PRODUCT});
            }
            this.setArchetypeNodes(nodes);
            result = super.apply(object, properties, parent, context);
        }
        finally {
            this.factory = null;
        }
        return result;
    }

    protected ComponentGrid createGrid(IMObject object, List<Property> properties, LayoutContext context, int columns) {
        ComponentGrid grid = super.createGrid(object, properties, context, columns);
        grid.add(this.getComponent(LABEL), columns);
        return grid;
    }

    protected ComponentState createNotes(IMObject object, Property property, LayoutContext context) {
        ComponentState notes = this.createComponent(property, object, context);
        Component component = notes.getComponent();
        if (component instanceof TextArea) {
            TextArea text = (TextArea)component;
            text.setWidth(Styles.FULL_WIDTH);
        }
        return notes;
    }

    protected void addButton(ButtonSet set) {
        super.addButton(set);
        set.add(this.newPrescription);
    }

    private ComponentState getReadOnlyComponent(Property property, IMObject parent, LayoutContext context) {
        if (this.factory == null) {
            this.factory = new ReadOnlyComponentFactory(context);
        }
        return this.factory.create(property, parent);
    }

    private void onNewPrescription(Act medication, final LayoutContext context) {
        final IMObjectBean bean = this.getBean((IMObject)medication);
        PrescriptionRules rules = (PrescriptionRules)ServiceHelper.getBean(PrescriptionRules.class);
        IMObjectCache cache = context.getCache();
        final Product product = (Product)cache.get(bean.getTargetRef(PRODUCT));
        final Party patient = (Party)cache.get(bean.getTargetRef("patient"));
        if (product != null && patient != null) {
            Act existing = rules.getPrescription(patient, product);
            if (existing != null) {
                int repeats = rules.getRemainingRepeats(existing);
                String title = Messages.get((String)"patient.prescription.existing.title");
                String message = Messages.format((String)"patient.prescription.existing.message", (Object[])new Object[]{product.getName(), repeats});
                ConfirmationDialog.show((String)title, (String)message, (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener(){

                    public void onYes() {
                        PatientMedicationActLayoutStrategy.this.createPrescription(bean, patient, product, context);
                    }
                });
            } else {
                this.createPrescription(bean, patient, product, context);
            }
        }
    }

    private void createPrescription(IMObjectBean medication, Party patient, Product product, LayoutContext context) {
        final Act prescription = (Act)IMObjectCreator.create((String)"act.patientPrescription");
        if (prescription != null) {
            IMObjectBean bean = this.getBean((IMObject)prescription);
            bean.setTarget("patient", (IMObject)patient);
            bean.setTarget(PRODUCT, (IMObject)product);
            bean.setValue(QUANTITY, medication.getValue(QUANTITY));
            bean.setValue(LABEL, medication.getValue(LABEL));
            bean.setTarget("clinician", (IMObject)context.getContext().getClinician());
            IMObjectEditorFactory factory = context.getEditorFactory();
            final IMObjectEditor editor = factory.create((IMObject)prescription, null, (LayoutContext)new DefaultLayoutContext(context.getContext(), context.getHelpContext()));
            EditDialog dialog = ((EditDialogFactory)ServiceHelper.getBean(EditDialogFactory.class)).create(editor, context.getContext());
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onClose(WindowPaneEvent event) {
                    if (PatientMedicationActLayoutStrategy.this.prescriptions != null && editor.isSaved()) {
                        PatientMedicationActLayoutStrategy.this.prescriptions.add(prescription);
                    }
                    super.onClose(event);
                }
            });
            dialog.show();
        }
    }
}

