/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.Quantity;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientActEditor;
import org.openvpms.web.component.im.product.BatchParticipationEditor;
import org.openvpms.web.component.im.product.ProductParticipationEditor;
import org.openvpms.web.component.im.util.LookupNameHelper;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.history.PatientHistoryDatingPolicy;
import org.openvpms.web.workspace.patient.mr.DispensingNotes;
import org.openvpms.web.workspace.patient.mr.PatientMedicationActLayoutStrategy;
import org.openvpms.web.workspace.patient.mr.Prescriptions;

public class PatientMedicationActEditor
extends PatientActEditor {
    private final ModifiableListener batchListener;
    private final DispensingNotes dispensingNotes;
    private final ProductRules productRules;
    private final ModifiableListener expiryDateListener;
    private final Quantity quantity;
    private final Label dispensingUnits;
    private boolean showProductReadOnly;
    private boolean prescription;
    private Prescriptions prescriptions;
    private Date batchExpiry;
    private static final String INSTRUCTIONS = "dispInstructions";
    private static final String BATCH = "batch";
    private static final String EXPIRY_DATE = "endTime";
    private static final String INVOICE_ITEM = "invoiceItem";
    private static final String PRESCRIPTION = "prescription";

    public PatientMedicationActEditor(Act act, Act parent, LayoutContext context) {
        super(act, parent, context);
        IMObjectBean bean;
        if (!act.isA("act.patientMedication")) {
            throw new IllegalArgumentException("Invalid act type:" + act.getArchetype());
        }
        this.productRules = (ProductRules)ServiceHelper.getBean(ProductRules.class);
        this.quantity = new Quantity(this.getProperty("quantity"), (IMObject)act, this.getLayoutContext());
        this.dispensingNotes = new DispensingNotes();
        this.dispensingUnits = LabelFactory.create();
        IMObjectBean medBean = this.getBean((IMObject)act);
        this.showProductReadOnly = medBean.getSourceRef(INVOICE_ITEM) != null;
        this.prescription = medBean.getObject(PRESCRIPTION) != null;
        this.batchListener = modifiable -> this.onBatchChanged();
        boolean updated = false;
        if (parent != null && (bean = this.getBean((IMObject)parent)).hasNode("product")) {
            Product product = (Product)this.getObject(bean.getTargetRef("product"));
            if (TypeHelper.isA((IMObject)product, (String)"product.medication")) {
                updated = this.setProduct(product);
                if (updated) {
                    Entity batch = null;
                    if (bean.hasNode(BATCH)) {
                        batch = (Entity)this.getObject(bean.getTargetRef(BATCH));
                    }
                    this.setBatch(batch);
                }
                this.setQuantity(bean.getBigDecimal("quantity"));
            } else {
                updated = this.setProduct(null);
            }
        }
        if (!updated) {
            Product product = this.getProduct();
            this.updateDispensingUnits(product);
            this.dispensingNotes.setProduct(product);
        }
        this.getBatchExpiry();
        this.expiryDateListener = modifiable -> this.onExpiryDateChanged();
        this.getProperty(EXPIRY_DATE).addModifiableListener(this.expiryDateListener);
    }

    public IMObjectEditor newInstance() {
        return new PatientMedicationActEditor((Act)this.reload((IMObject)this.getObject()), (Act)this.getParent(), this.getLayoutContext());
    }

    public boolean setProduct(Product product) {
        boolean result = this.setParticipant("product", (Entity)product);
        if (result && this.getProductEditor() == null) {
            this.productModified(product);
            if (this.showProductReadOnly && this.getView().hasComponent()) {
                this.onLayout();
            }
        }
        return result;
    }

    public Product getProduct() {
        return (Product)this.getParticipant("product");
    }

    public void setProductReadOnly(boolean readOnly) {
        this.showProductReadOnly = readOnly;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity.setValue(quantity, false);
    }

    public void setQuantity(Quantity quantity) {
        this.quantity.setValue(quantity.getValue(), quantity.isDefault());
    }

    public BigDecimal getQuantity() {
        return this.quantity.getValue();
    }

    public void setDispensedFromPrescription(boolean prescription) {
        this.prescription = prescription;
    }

    public void setLabel(String instructions) {
        Property label = this.getProperty("label");
        label.setValue((Object)instructions);
    }

    public void setStockLocation(Reference stockLocation) {
        BatchParticipationEditor batchEditor = this.getBatchEditor();
        if (batchEditor != null) {
            batchEditor.setStockLocation(stockLocation);
        }
    }

    public void setBatch(Entity batch) {
        if (this.setParticipant(BATCH, batch) && this.getBatchEditor() == null) {
            this.onBatchChanged();
        }
    }

    public Entity getBatch() {
        return this.getParticipant(BATCH);
    }

    public void setPrescriptions(Prescriptions prescriptions) {
        this.prescriptions = prescriptions;
    }

    public void setExpiryDate(Date date) {
        this.getProperty(EXPIRY_DATE).setValue((Object)date);
    }

    public Date getExpiryDate() {
        return this.getProperty(EXPIRY_DATE).getDate();
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateBatchExpiry(validator);
    }

    protected boolean validateStartEndTimes(Validator validator) {
        return true;
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        PatientMedicationActLayoutStrategy strategy = new PatientMedicationActLayoutStrategy(){

            @Override
            public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
                PatientHistoryDatingPolicy policy = (PatientHistoryDatingPolicy)ServiceHelper.getBean(PatientHistoryDatingPolicy.class);
                if (!policy.canEditStartTime((Act)object)) {
                    this.addComponent(this.createComponent(this.createReadOnly(properties.get("startTime")), object, context));
                }
                Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{PatientMedicationActEditor.this.quantity.getComponent(), PatientMedicationActEditor.this.dispensingUnits});
                this.addComponent(new ComponentState((Component)row, PatientMedicationActEditor.this.quantity.getProperty()));
                return super.apply(object, properties, parent, context);
            }

            @Override
            protected ComponentGrid createGrid(IMObject object, List<Property> properties, LayoutContext context, int columns) {
                ComponentGrid grid = super.createGrid(object, properties, context, columns);
                ComponentState usage = PatientMedicationActEditor.this.dispensingNotes.getComponent(context);
                Column label = ColumnFactory.create((Component[])new Component[]{usage.getLabel()});
                Column text = ColumnFactory.create((Component[])new Component[]{usage.getComponent()});
                text.setLayoutData((LayoutData)ComponentGrid.layout((int)1, (int)(columns * 2 - 1)));
                grid.add(new Component[]{label, text});
                return grid;
            }
        };
        strategy.setProductReadOnly(this.showProductReadOnly);
        strategy.setDispensedFromPrescription(this.prescription);
        strategy.setPrescriptions(this.prescriptions);
        return strategy;
    }

    protected void onLayoutCompleted() {
        BatchParticipationEditor batch;
        ProductParticipationEditor product = this.getProductEditor();
        if (product != null) {
            product.setPatient(this.getPatient());
            product.addModifiableListener(modifiable -> this.productModified((Product)product.getEntity()));
        }
        if ((batch = this.getBatchEditor()) != null) {
            batch.setProduct(this.getProduct());
            batch.addModifiableListener(this.batchListener);
        }
        super.onLayoutCompleted();
    }

    protected void productModified(Product product) {
        IMObjectBean bean;
        if (product != null && (bean = this.getBean((IMObject)product)).hasNode(INSTRUCTIONS)) {
            String dispInstructions = bean.getString(INSTRUCTIONS);
            this.setLabel(dispInstructions);
        }
        this.updateDispensingUnits(product);
        this.dispensingNotes.setProduct(product);
        this.updateBatch(product);
    }

    protected ProductParticipationEditor getProductEditor() {
        ParticipationEditor editor = this.getParticipationEditor("product", false);
        return (ProductParticipationEditor)editor;
    }

    protected BatchParticipationEditor getBatchEditor() {
        ParticipationEditor editor = this.getParticipationEditor(BATCH, false);
        return (BatchParticipationEditor)editor;
    }

    private void onExpiryDateChanged() {
        Date date;
        if (this.batchExpiry != null && ((date = this.getExpiryDate()) == null || DateRules.compareTo((Date)date, (Date)this.batchExpiry) > 0)) {
            Property property = this.getProperty(EXPIRY_DATE);
            try {
                property.removeModifiableListener(this.expiryDateListener);
                this.setExpiryDate(this.batchExpiry);
            }
            finally {
                property.addModifiableListener(this.expiryDateListener);
            }
        }
    }

    private boolean validateBatchExpiry(Validator validator) {
        Date date;
        boolean valid = true;
        if (this.batchExpiry != null && ((date = this.getExpiryDate()) == null || DateRules.compareDates((Date)date, (Date)this.batchExpiry) > 0)) {
            String message = Messages.format((String)"patient.medication.expiry.invalid", (Object[])new Object[]{DateFormatter.formatDate((Date)this.batchExpiry, (boolean)false)});
            validator.add((Modifiable)this, new ValidatorError(this.getProperty(EXPIRY_DATE), message));
            valid = false;
        }
        return valid;
    }

    private void updateDispensingUnits(Product product) {
        String units = "";
        if (TypeHelper.isA((IMObject)product, (String)"product.medication")) {
            units = LookupNameHelper.getName((IMObject)product, (String)"dispensingUnits");
        }
        this.dispensingUnits.setText(units);
    }

    private void updateBatch(Product product) {
        BatchParticipationEditor editor = this.getBatchEditor();
        if (editor != null) {
            editor.removeModifiableListener(this.batchListener);
            try {
                editor.setProduct(product);
            }
            finally {
                editor.addModifiableListener(this.batchListener);
            }
            this.onBatchChanged();
        }
    }

    private void onBatchChanged() {
        this.setExpiryDate(this.getBatchExpiry());
    }

    private Date getBatchExpiry() {
        Entity batch = this.getBatch();
        this.batchExpiry = null;
        if (batch != null) {
            this.batchExpiry = this.productRules.getBatchExpiry(batch);
        }
        return this.batchExpiry;
    }
}

