/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.io.IOException;
import org.openvpms.archetype.rules.doc.BaseDocumentTemplate;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.TemporaryDocumentHandler;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.laboratory.internal.service.OrdersImpl;
import org.openvpms.laboratory.order.Document;
import org.openvpms.laboratory.order.Order;
import org.openvpms.laboratory.service.LaboratoryService;
import org.openvpms.laboratory.service.LaboratoryServices;
import org.openvpms.report.IMReport;
import org.openvpms.report.ReportException;
import org.openvpms.report.ReportFactory;
import org.openvpms.report.i18n.ReportMessages;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.TemplatedReporter;
import org.openvpms.web.system.ServiceHelper;

public class PatientInvestigationFormReporter
extends TemplatedReporter<DocumentAct> {
    private final ReportFactory reportFactory;
    private final OrdersImpl orders;
    private final LaboratoryServices laboratoryServices;
    private IMReport<DocumentAct> report;

    public PatientInvestigationFormReporter(DocumentAct act, FileNameFormatter formatter, ArchetypeService service, LookupService lookups, ReportFactory reportFactory) {
        super((Object)act, (DocumentTemplateLocator)new InvestigationTypeTemplateLocator(act, service), formatter, service, lookups);
        this.reportFactory = reportFactory;
        this.orders = (OrdersImpl)ServiceHelper.getBean(OrdersImpl.class);
        this.laboratoryServices = (LaboratoryServices)ServiceHelper.getBean(LaboratoryServices.class);
    }

    public boolean hasDocument() {
        try {
            this.getReport();
        }
        catch (ReportException reportException) {
            // empty catch block
        }
        return this.report != null;
    }

    protected IMReport<DocumentAct> getReport() {
        if (this.report == null) {
            this.report = this.createReport();
        }
        return this.report;
    }

    protected IMReport<DocumentAct> createReport() {
        DocumentTemplate template = this.getTemplate();
        IMReport result = template != null ? (this.reportFactory.isIMObjectReport((BaseDocumentTemplate)template) ? this.reportFactory.createIMObjectReport((BaseDocumentTemplate)template) : this.reportFactory.createStaticContentReport(template)) : this.createLaboratoryReport();
        if (result == null) {
            String displayName = DescriptorHelper.getDisplayName((IMObject)((IMObject)this.getObject()), (ArchetypeService)this.getService());
            throw new ReportException(ReportMessages.noDocument((String)displayName));
        }
        return result;
    }

    private IMReport<IMObject> createLaboratoryReport() {
        LaboratoryService laboratoryService;
        Document document;
        Order order;
        DocumentAct investigation;
        IMReport result = null;
        ArchetypeService service = this.getService();
        Entity laboratory = (Entity)service.getBean((IMObject)(investigation = (DocumentAct)this.getObject())).getTarget("laboratory", Entity.class);
        if (laboratory != null && (order = this.orders.getOrder((Act)investigation)) != null && (document = (laboratoryService = this.laboratoryServices.getService(laboratory)).getRequestForm(order)) != null) {
            result = this.reportFactory.createStaticContentReport(this.convert(document));
        }
        return result;
    }

    private org.openvpms.component.model.document.Document convert(Document document) {
        try {
            TemporaryDocumentHandler handler = new TemporaryDocumentHandler(this.getService());
            return handler.create(document.getName(), document.getInputStream(), document.getMimeType(), -1);
        }
        catch (IOException exception) {
            throw new ReportException(ReportMessages.failedToCreateReport((String)document.getName(), (String)exception.getMessage()), (Throwable)exception);
        }
    }

    private static class InvestigationTypeTemplateLocator
    implements DocumentTemplateLocator {
        DocumentTemplate template;
        private final DocumentAct investigation;
        private final ArchetypeService service;

        public InvestigationTypeTemplateLocator(DocumentAct investigation, ArchetypeService service) {
            this.investigation = investigation;
            this.service = service;
        }

        public DocumentTemplate getTemplate() {
            IMObjectBean bean;
            Entity entity;
            IMObjectBean act;
            Entity investigationType;
            if (this.template == null && (investigationType = (Entity)(act = this.service.getBean((IMObject)this.investigation)).getTarget("investigationType", Entity.class)) != null && (entity = (Entity)(bean = this.service.getBean((IMObject)investigationType)).getTarget("template", Entity.class)) != null) {
                this.template = new DocumentTemplate(entity, this.service);
            }
            return this.template;
        }

        public String getType() {
            return this.template != null ? this.template.getType() : "act.patientDocumentForm";
        }
    }
}

