/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.im.doc.DocumentActEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.workspace.patient.history.PatientHistoryActions;
import org.openvpms.web.workspace.patient.mr.PatientDocumentActLayoutStrategy;

public class PatientDocumentActEditor
extends DocumentActEditor {
    public PatientDocumentActEditor(DocumentAct act, IMObject parent, LayoutContext context) {
        super(act, parent, context);
        ActRelationshipCollectionEditor versions;
        if (act.isNew()) {
            IMObjectBean bean;
            boolean initPatient = false;
            if (parent instanceof Act && (bean = this.getBean(parent)).hasNode("patient")) {
                this.initParticipant("patient", bean.getTargetRef("patient"));
                initPatient = true;
            }
            if (!initPatient) {
                this.initParticipant("patient", (IMObject)context.getContext().getPatient());
            }
        }
        if ((versions = this.getVersionsEditor()) != null && this.isLocked()) {
            versions.setCardinalityReadOnly(true);
        }
    }

    public void setPatient(Party patient) {
        this.setPatient(patient != null ? patient.getObjectReference() : null);
    }

    public void setPatient(Reference patient) {
        this.setParticipant("patient", patient);
    }

    public Reference getPatientRef() {
        return this.getParticipantRef("patient");
    }

    public void setClinician(User clinician) {
        this.setParticipant("clinician", (Entity)clinician);
    }

    public void setClinician(IMObjectReference clinician) {
        this.setParticipant("clinician", (Reference)clinician);
    }

    public boolean isLocked() {
        String status = this.getStatus();
        return "POSTED".equals(status) || "CANCELLED".equals(status) || PatientHistoryActions.needsLock((Act)this.getObject());
    }

    public IMObjectEditor newInstance() {
        return new PatientDocumentActEditor((DocumentAct)this.reload((IMObject)this.getObject()), this.getParent(), this.getLayoutContext());
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new PatientDocumentActLayoutStrategy(this.getDocumentEditor(), this.getVersionsEditor(), this.isLocked());
    }
}

