/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.util.List;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.list.ListCellRenderer;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.web.component.alert.Alert;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.edit.SelectFieldIMObjectReferenceEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.list.IMObjectListCellRenderer;
import org.openvpms.web.component.im.list.StyledListCell;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.system.ServiceHelper;

public class AlertTypeParticipationEditor
extends ParticipationEditor<Entity> {
    public AlertTypeParticipationEditor(Participation participation, Act parent, LayoutContext context) {
        super(participation, parent, context);
    }

    protected IMObjectReferenceEditor<Entity> createEntityEditor(Property property) {
        SelectFieldIMObjectReferenceEditor<Entity> editor = new SelectFieldIMObjectReferenceEditor<Entity>(property, this.getAlertTypes(), false){

            protected void modified() {
                super.modified();
                AlertTypeParticipationEditor.this.refresh((SelectFieldIMObjectReferenceEditor<Entity>)this);
            }
        };
        editor.setListCellRenderer((ListCellRenderer)new AlertTypeCellRenderer());
        this.refresh(editor);
        return editor;
    }

    private void refresh(SelectFieldIMObjectReferenceEditor<Entity> editor) {
        IMObject selected = editor.getObject();
        if (selected != null) {
            Alert alert = new Alert(selected);
            Color background = alert.getColour();
            Color foreground = alert.getTextColour();
            editor.getComponent().setBackground(background);
            editor.getComponent().setForeground(foreground);
        }
    }

    private List<Entity> getAlertTypes() {
        ArchetypeQuery query = new ArchetypeQuery("entity.patientAlertType", true, true);
        query.setMaxResults(-1);
        return ServiceHelper.getArchetypeService().get((IArchetypeQuery)query).getResults();
    }

    private static class AlertTypeCellRenderer
    extends IMObjectListCellRenderer {
        public AlertTypeCellRenderer() {
            super(IMObjectListCellRenderer.Node.NAME);
        }

        protected Object getComponent(Component list, IMObject object, int index) {
            if (object != null) {
                Alert alert = new Alert(object);
                Color background = alert.getColour();
                Color foreground = alert.getTextColour();
                return new StyledListCell(object.getName(), background, foreground);
            }
            return null;
        }
    }
}

