/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.util.Objects;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SplitPane;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.text.TextArea;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.history.PatientHistoryBrowser;
import org.openvpms.web.workspace.patient.history.PatientHistoryQuery;

public abstract class AbstractPatientClinicalNoteEditDialog
extends EditDialog {
    private PatientHistoryBrowser browser;

    public AbstractPatientClinicalNoteEditDialog(IMObjectEditor editor, Context context) {
        super(editor, context);
    }

    protected void onApply() {
        super.onApply();
        if (this.browser != null) {
            Act event = this.getCurrentEvent();
            if (this.browser.getObjects().contains(event)) {
                this.browser.query();
                this.browser.setSelected(event, true);
            }
        }
    }

    protected void setComponent(Component component, FocusGroup group, HelpContext context, boolean focus) {
        Party patient = this.getPatient();
        PatientHistoryQuery query = new PatientHistoryQuery(patient, ServiceHelper.getPreferences());
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.getContext(), context);
        this.browser = new PatientHistoryBrowser(query, (LayoutContext)layoutContext){

            @Override
            protected void initTable(PagedIMTable<Act> table) {
                super.initTable(table);
                table.getTable().setSelectionEnabled(false);
            }
        };
        SplitPane pane = SplitPaneFactory.create((int)5, (String)this.getLayoutStyleName(), (Component[])new Component[]{component, this.browser.getComponent()});
        group.add(this.browser.getFocusGroup());
        this.browser.setSelected(this.getCurrentEvent(), true);
        super.setComponent((Component)pane, group, context, focus);
    }

    protected abstract Party getPatient();

    protected abstract String getLayoutStyleName();

    protected Act getCurrentEvent() {
        return (Act)this.getContext().getObject("act.patientClinicalEvent");
    }

    protected void reloaded(String title, String message, IMObjectEditor oldEditor) {
        String oldNote = StringUtils.trimToNull((String)this.getNote(oldEditor));
        boolean prompt = false;
        if (oldNote != null) {
            IMObjectEditor newEditor = this.getEditor();
            if (newEditor != null) {
                String newNote = StringUtils.trimToNull((String)this.getNote(newEditor));
                if (!Objects.equals(oldNote, newNote)) {
                    prompt = true;
                }
            } else {
                prompt = true;
            }
        }
        if (prompt) {
            String displayName = DescriptorHelper.getDisplayName((String)"act.patientClinicalNote", (String)"note", (ArchetypeService)ServiceHelper.getArchetypeService());
            message = message + "\n\n" + Messages.format((String)"imobject.save.reverted.copy", (Object[])new Object[]{displayName});
            ((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)NoteErrorDialog.newDialog().title(title)).preamble(message)).message(oldNote)).size("PatientClinicalNote.NoteError.size")).show();
        } else {
            super.reloaded(title, message, oldEditor);
        }
    }

    protected abstract String getNote(IMObjectEditor var1);

    private static class NoteErrorDialog
    extends ErrorDialog {
        protected NoteErrorDialog(ErrorDialogBuilder builder) {
            super(builder);
        }

        public static ErrorDialogBuilder newDialog() {
            return new ErrorDialogBuilder(){

                public ErrorDialog build() {
                    return new NoteErrorDialog(this);
                }
            };
        }

        protected TextArea createTextArea(String message) {
            TextArea text = super.createTextArea(message);
            text.setEnabled(true);
            return text;
        }
    }
}

