/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.investigation;

import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.laboratory.order.Order;
import org.openvpms.laboratory.service.LaboratoryService;
import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.investigation.InvestigationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultChecker {
    private final DocumentAct investigation;
    private Order order;
    private static final Logger log = LoggerFactory.getLogger(ResultChecker.class);

    public ResultChecker(DocumentAct investigation) {
        this.investigation = investigation;
    }

    public DocumentAct getInvestigation() {
        return this.investigation;
    }

    public boolean canCheckResults() {
        boolean result = false;
        String status = this.investigation.getStatus2();
        if (!("CANCELLED".equals(this.investigation.getStatus()) || "PENDING".equals(status) || "CONFIRM".equals(status) || "CONFIRM_DEFERRED".equals(status) || "ERROR".equals(status))) {
            result = ServiceHelper.getArchetypeService().getBean((IMObject)this.investigation).getBoolean("checkResults");
        }
        return result;
    }

    public boolean checkResults() {
        boolean results = false;
        try {
            LaboratoryService service;
            Order order = this.getOrder();
            if (order != null && !(results = order.getReport().hasExternalResults()) && (service = InvestigationHelper.getLaboratoryService(order)).canCheck(order) && service.check(order)) {
                results = order.getReport().hasExternalResults();
            }
            if (!results) {
                InformationDialog.show((String)Messages.get((String)"investigation.checkResults.title"), (String)Messages.get((String)"investigation.noresults"));
            }
        }
        catch (Throwable exception) {
            log.error("Failed to check results: " + exception.getMessage(), exception);
            ((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)ErrorDialog.newDialog().title(Messages.get((String)"investigation.checkResults.title"))).preamble(Messages.get((String)"investigation.checkResults.error"))).message(ErrorFormatter.format((Throwable)exception))).show();
        }
        return results;
    }

    Order getOrder() {
        if (this.order == null) {
            this.order = InvestigationHelper.getOrder(this.investigation.getId());
        }
        return this.order;
    }
}

