/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.investigation;

import java.util.List;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.edit.PropertyComponentEditor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.doc.DocumentEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.edit.act.ParticipationCollectionEditor;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.lookup.LookupField;
import org.openvpms.web.component.im.lookup.LookupFieldFactory;
import org.openvpms.web.component.im.lookup.LookupFilter;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.print.IMObjectReportPrinter;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.openvpms.web.component.im.report.TemplatedReporter;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.investigation.InvestigationViewer;
import org.openvpms.web.workspace.patient.mr.PatientDocumentActLayoutStrategy;
import org.openvpms.web.workspace.patient.mr.PatientInvestigationFormReporter;

public class PatientInvestigationActLayoutStrategy
extends PatientDocumentActLayoutStrategy {
    public static final String ORDER_ID = "orderId";
    public static final String REPORT_ID = "reportId";
    public static final String ORDER_STATUS = "status2";
    public static final String LABORATORY = "laboratory";
    public static final String DEVICE = "device";
    public static final String SUMMARY = "summary";
    public static final String STATUS = "status";
    public static final String TESTS = "tests";
    public static final String PRODUCTS = "products";
    public static final String INVESTIGATION_TYPE = "investigationType";
    public static final String RESULTS = "results";
    public static final String VERSIONS = "versions";
    public static final String MESSAGE = "message";
    private boolean enablePrint = true;
    private boolean inlineOrderStatusMessage = false;
    private static final String ID = "id";

    public PatientInvestigationActLayoutStrategy() {
        this(null, null, null, null, false);
    }

    public PatientInvestigationActLayoutStrategy(DocumentEditor editor, ActRelationshipCollectionEditor versionsEditor, ParticipationCollectionEditor deviceEditor, PropertyComponentEditor orderStatusEditor, boolean locked) {
        super(editor, versionsEditor, locked);
        if (deviceEditor != null) {
            this.addComponent(new ComponentState((PropertyEditor)deviceEditor));
        }
        if (orderStatusEditor != null) {
            this.addComponent(new ComponentState((PropertyEditor)orderStatusEditor));
        }
    }

    public void setEnableButton(boolean enable) {
        this.enablePrint = enable;
    }

    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        ArchetypeNodes nodes = new ArchetypeNodes(EDIT_NODES).excludeIfEmpty(new String[]{ORDER_ID, REPORT_ID, MESSAGE, TESTS, PRODUCTS, RESULTS, VERSIONS, LABORATORY}).exclude(new String[]{SUMMARY});
        if (!context.isEdit()) {
            nodes.excludeIfEmpty(new String[]{DEVICE});
        }
        if (this.enablePrint || !object.isNew()) {
            nodes.simple(new String[]{ID});
        }
        IMObjectBean bean = this.getBean(object);
        if (this.enablePrint) {
            Button print = ButtonFactory.create((String)"button.printform", () -> PatientInvestigationActLayoutStrategy.printForm((DocumentAct)object, context));
            ComponentState id = this.createComponent(properties.get(ID), object, context);
            Row row = RowFactory.create((String)"WideCellSpacing", (Component[])new Component[]{id.getComponent(), RowFactory.create((LayoutData)RowFactory.rightAlign(), (Component[])new Component[]{print})});
            this.addComponent(new ComponentState((Component)row, id.getProperty()));
        }
        Entity laboratory = (Entity)context.getCache().get(bean.getTargetRef(LABORATORY));
        IMObjectComponentFactory factory = context.getComponentFactory();
        if (context.isEdit()) {
            boolean hasLaboratory;
            boolean bl = hasLaboratory = laboratory != null;
            if (hasLaboratory || this.isLocked()) {
                if (hasLaboratory) {
                    this.addComponent(factory.create(this.createReadOnly(properties.get(STATUS)), object));
                } else {
                    this.addComponent(this.createStatus(object, properties));
                }
                this.addComponent(factory.create(this.createReadOnly(properties.get(INVESTIGATION_TYPE)), object));
            }
            boolean editDevice = false;
            if (hasLaboratory) {
                Property orderStatus = properties.get(ORDER_STATUS);
                editDevice = "PENDING".equals(orderStatus.getString());
            }
            if (!editDevice) {
                if (bean.getTargetRef(DEVICE) != null) {
                    this.addComponent(factory.create(this.createReadOnly(properties.get(DEVICE)), object));
                } else {
                    nodes.exclude(new String[]{DEVICE});
                }
            }
        } else {
            this.addComponent(this.createDocumentViewer(object, properties, context));
        }
        Property message = properties.get(MESSAGE);
        if (message != null && message.getString() != null) {
            this.inlineOrderStatusMessage = true;
            ComponentState orderStatus = this.getComponent(ORDER_STATUS);
            if (orderStatus == null) {
                orderStatus = this.createComponent(properties.get(ORDER_STATUS), object, context);
            }
            ComponentState text = this.createMultiLineText(message, 1, 20, Styles.FULL_WIDTH, context);
            text.getComponent().setLayoutData(RowFactory.layout((Extent)Styles.FULL_WIDTH));
            this.addComponent(this.createComponentPair(orderStatus, text));
            nodes.exclude(new String[]{ORDER_STATUS, MESSAGE});
        } else {
            this.inlineOrderStatusMessage = false;
        }
        Property summary = properties.get(SUMMARY);
        if (summary.getString() != null) {
            this.addComponent(this.createMultiLineText(summary, 1, 20, Styles.FULL_WIDTH, context));
        }
        this.setArchetypeNodes(nodes);
        return super.apply(object, properties, parent, context);
    }

    protected void doSimpleLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
        ComponentState orderStatus;
        ComponentGrid grid = this.createGrid(object, properties, context);
        if (this.inlineOrderStatusMessage && (orderStatus = this.getComponent(ORDER_STATUS)) != null) {
            grid.add(orderStatus, 2);
        }
        this.addAuditInfo(object, grid, context);
        ComponentState summary = this.getComponent(SUMMARY);
        if (summary != null) {
            grid.add(summary, 2);
        }
        container.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{this.createGrid(grid)}));
    }

    @Override
    protected boolean makeReadOnly(Property property) {
        String name = property.getName();
        return !property.isReadOnly() && !ORDER_STATUS.equals(name);
    }

    private ComponentState createDocumentViewer(IMObject object, PropertySet properties, LayoutContext context) {
        Property property = properties.get("document");
        InvestigationViewer viewer = new InvestigationViewer((DocumentAct)object, true, context);
        return new ComponentState(viewer.getComponent(), property);
    }

    private ComponentState createStatus(IMObject object, PropertySet properties) {
        Property property = properties.get(STATUS);
        NodeLookupQuery query = new NodeLookupQuery(object, property);
        String status = property.getString();
        if ("POSTED".equals(status) || "CANCELLED".equals(status)) {
            query = new LookupFilter((LookupQuery)query, true, new String[]{"POSTED", "CANCELLED"});
        }
        LookupField field = LookupFieldFactory.create((Property)property, (LookupQuery)query);
        return new ComponentState((Component)field, property);
    }

    private static void printForm(DocumentAct investigation, LayoutContext layoutContext) {
        Context context;
        ContextDocumentTemplateLocator locator;
        ReporterFactory reporterFactory = (ReporterFactory)ServiceHelper.getBean(ReporterFactory.class);
        PatientInvestigationFormReporter reporter = (PatientInvestigationFormReporter)reporterFactory.create((IMObject)investigation, (DocumentTemplateLocator)(locator = new ContextDocumentTemplateLocator((IMObject)investigation, context = layoutContext.getContext())), PatientInvestigationFormReporter.class);
        if (reporter.hasDocument()) {
            IMPrinterFactory factory = (IMPrinterFactory)ServiceHelper.getBean(IMPrinterFactory.class);
            IMObjectReportPrinter printer = factory.createIMObjectReportPrinter((TemplatedReporter)reporter, context);
            InteractiveIMPrinter interactive = new InteractiveIMPrinter((IMPrinter)printer, context, layoutContext.getHelpContext());
            interactive.setMailContext(layoutContext.getMailContext());
            interactive.print();
        } else {
            InformationDialog.show((String)Messages.get((String)"printdialog.title"), (String)Messages.get((String)"investigation.print.noform"));
        }
    }
}

