/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.util.Collections;
import java.util.List;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.contact.ContactHelper;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.CustomerMailContext;

public class InsurerMailContext
extends CustomerMailContext {
    public InsurerMailContext(Context context, HelpContext help) {
        super(context, help);
    }

    public Party getInsurer() {
        return this.getContext().getSupplier();
    }

    @Override
    protected CustomerMailContext.AddressState createToAddressState(CustomerMailContext.AddressStateBuilder builder) {
        Party insurer = this.getInsurer();
        builder.addParty("party.supplierInsurer", insurer);
        List contacts = insurer != null ? ContactHelper.getEmailContacts((Party)insurer, (ArchetypeService)this.getService()) : Collections.emptyList();
        Contact preferred = !contacts.isEmpty() ? (Contact)contacts.get(0) : null;
        builder.addContacts(contacts);
        builder.setPreferred(preferred);
        return super.createToAddressState(builder);
    }

    @Override
    protected boolean toAddressesOutOfDate(CustomerMailContext.AddressState state) {
        return super.toAddressesOutOfDate(state) || !state.matches("party.supplierInsurer", this.getInsurer());
    }
}

