/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.insurance.internal.claim.GapClaimImpl;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.component.error.ExceptionHelper;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.workflow.EditIMObjectTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditDialog;
import org.openvpms.web.workspace.patient.insurance.claim.GapPaymentEditor;

class GapPaymentRefundEditTask
extends EditIMObjectTask {
    private final GapClaimImpl claim;
    private final Party gapLocation;
    private final Entity gapBenefitTill;
    private final boolean tillRequired;
    private final BigDecimal amount;
    private final boolean payment;
    private final BigDecimal paid;
    private static final Log log = LogFactory.getLog(GapPaymentRefundEditTask.class);

    public GapPaymentRefundEditTask(GapClaimImpl claim, BigDecimal amount, boolean payment, BigDecimal paid) {
        super(payment ? "act.customerAccountPayment" : "act.customerAccountRefund", true);
        this.claim = claim;
        this.gapLocation = claim.getLocationParty();
        this.amount = amount;
        this.payment = payment;
        this.paid = paid;
        LocationRules rules = (LocationRules)ServiceHelper.getBean(LocationRules.class);
        this.gapBenefitTill = rules.getGapBenefitTill(this.gapLocation);
        this.tillRequired = !MathRules.isZero((BigDecimal)claim.getBenefitAmount()) && (!payment || amount.add(paid).equals(claim.getGapAmount()));
    }

    protected EditDialog createEditDialog(IMObjectEditor editor, boolean skip, TaskContext context) {
        return new ReloadingPaymentEditDialog((GapPaymentEditor)editor, this.claim, context);
    }

    protected IMObjectEditor createEditor(IMObject object, TaskContext context) {
        DefaultLayoutContext layout = new DefaultLayoutContext(true, (Context)context, context.getHelpContext());
        return new GapPaymentEditor((FinancialAct)object, null, (LayoutContext)layout, this.amount, this.gapLocation, this.gapBenefitTill, this.tillRequired);
    }

    private class ReloadingPaymentEditDialog
    extends CustomerPaymentEditDialog {
        private GapClaimImpl claim;

        ReloadingPaymentEditDialog(GapPaymentEditor editor, GapClaimImpl claim, TaskContext context) {
            super(editor, (List<FinancialAct>)claim.getInvoices(), (Context)context);
            this.claim = claim;
        }

        @Override
        protected void onOKCompleted() {
            this.updateClaimAndClose();
        }

        @Override
        protected boolean reload(IMObjectEditor editor) {
            boolean result = false;
            if (super.reload(editor)) {
                try {
                    this.claim = this.claim.reload();
                    result = true;
                }
                catch (Exception exception) {
                    log.warn((Object)("Failed to reload claim: " + exception.getMessage()), (Throwable)exception);
                }
            }
            return result;
        }

        private void updateClaimAndClose() {
            try {
                this.updateClaim();
                super.onOKCompleted();
            }
            catch (Exception exception) {
                String displayName = DescriptorHelper.getDisplayName((String)"act.patientInsuranceClaim", (ArchetypeService)ServiceHelper.getArchetypeService());
                String message = ErrorFormatter.format((Throwable)exception, (String)displayName);
                message = ExceptionHelper.isModifiedExternally((Throwable)ExceptionUtils.getRootCause((Throwable)exception)) ? Messages.format((String)"patient.insurance.pay.retry", (Object[])new Object[]{message}) : Messages.format((String)"patient.insurance.pay.failwithretry", (Object[])new Object[]{message});
                ((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)ErrorDialog.newDialog().message(message)).yes(this::retryUpdateClaim)).no(() -> ((ReloadingPaymentEditDialog)this).onCancel())).show();
            }
        }

        private void updateClaim() {
            GapPaymentEditor paymentEditor = (GapPaymentEditor)this.getEditor();
            FinancialAct act = paymentEditor.getObject();
            Context context = this.getContext();
            if (GapPaymentRefundEditTask.this.payment) {
                BigDecimal total = act.getTotal().add(GapPaymentRefundEditTask.this.paid);
                if (total.compareTo(this.claim.getTotal()) >= 0) {
                    this.claim.fullyPaid();
                } else if (total.compareTo(this.claim.getGapAmount()) == 0) {
                    this.claim.gapPaid(paymentEditor.getGapPaymentTill(), context.getLocation());
                }
            } else {
                this.claim.gapPaid(paymentEditor.getGapPaymentTill(), context.getLocation());
            }
        }

        private void retryUpdateClaim() {
            boolean retry = false;
            try {
                this.claim = this.claim.reload();
                retry = true;
            }
            catch (Exception exception) {
                log.warn((Object)("Failed to reload claim: " + exception.getMessage()), (Throwable)exception);
                String displayName = DescriptorHelper.getDisplayName((String)"act.patientInsuranceClaim", (ArchetypeService)ServiceHelper.getArchetypeService());
                String message = ErrorFormatter.format((Throwable)exception, (String)displayName);
                ((ErrorDialogBuilder)((ErrorDialogBuilder)ErrorDialog.newDialog().message(message)).ok(() -> ((ReloadingPaymentEditDialog)this).onCancel())).show();
            }
            if (retry) {
                this.updateClaimAndClose();
            }
        }
    }
}

