/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.math.BigDecimal;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.button.ButtonGroup;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.claim.GapClaim;
import org.openvpms.insurance.internal.claim.GapClaimImpl;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.text.TextComponent;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.patient.insurance.claim.GapClaimSummary;

class GapPaymentPrompt
extends ModalDialog {
    private final RadioButton gapButton;
    private final RadioButton fullButton;
    private final RadioButton confirmGapButton;
    private final GapClaimSummary summary;
    private final boolean refund;
    private String prompt;

    public GapPaymentPrompt(GapClaimImpl claim, boolean payFullClaim, HelpContext help) {
        super(Messages.get((String)"patient.insurance.pay.title"), OK_CANCEL, help);
        boolean disableGap;
        this.summary = new GapClaimSummary(claim);
        Claim.Status status = claim.getStatus();
        GapClaim.GapStatus gapStatus = claim.getGapStatus();
        ButtonGroup group = new ButtonGroup();
        this.refund = this.summary.canRefund();
        String gapText = this.refund ? "patient.insurance.pay.refund" : "patient.insurance.pay.gap";
        String fullText = this.refund ? "patient.insurance.pay.payfull" : "patient.insurance.pay.full";
        this.gapButton = ButtonFactory.create((String)gapText, (ButtonGroup)group, this::enableOK);
        this.fullButton = ButtonFactory.create((String)fullText, (ButtonGroup)group, this::enableOK);
        this.confirmGapButton = this.summary.canConfirmGap() ? ButtonFactory.create((String)"patient.insurance.pay.confirmgap", (ButtonGroup)group, this::enableOK) : null;
        boolean preSettled = status == Claim.Status.PRE_SETTLED;
        boolean gapAllowed = this.summary.canPayGap();
        boolean bl = disableGap = !gapAllowed && !this.refund;
        if (disableGap) {
            this.gapButton.setEnabled(false);
        }
        if (preSettled) {
            if (!disableGap) {
                this.gapButton.setSelected(true);
            }
        } else if (payFullClaim || disableGap) {
            this.fullButton.setSelected(true);
        }
        ComponentGrid grid = new ComponentGrid();
        BigDecimal paid = this.getPaid();
        if (MathRules.isZero((BigDecimal)paid)) {
            grid.add(new Component[]{LabelFactory.create((String)"patient.insurance.pay")});
        } else if (this.refund) {
            grid.add(new Component[]{LabelFactory.create((String)"patient.insurance.pay.refundorpay")});
        } else {
            grid.add(new Component[]{LabelFactory.create((String)"patient.insurance.pay.remaining")});
        }
        BigDecimal remaining = this.refund ? this.summary.getRefundAmount() : this.summary.getRemainingGapAmount();
        TextComponent gapField = TextComponentFactory.createAmount((BigDecimal)remaining, (int)10, (boolean)true);
        if (disableGap) {
            gapField.setStyleName("edit");
        }
        grid.add(new Component[]{this.gapButton, gapField});
        if (!preSettled) {
            grid.add(new Component[]{this.fullButton, TextComponentFactory.createAmount((BigDecimal)this.summary.getRemainingFullAmount(), (int)10, (boolean)true)});
        }
        if (this.confirmGapButton != null) {
            grid.add(new Component[]{this.confirmGapButton});
        }
        Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{this.summary.getComponent(), grid.createGrid()});
        if (gapAllowed) {
            this.prompt = gapStatus == GapClaim.GapStatus.PENDING ? Messages.get((String)"patient.insurance.pay.nobenefitdesc") : (preSettled ? Messages.get((String)"patient.insurance.pay.presettled") : Messages.get((String)"patient.insurance.pay.gapdesc"));
        } else if (this.refund) {
            this.prompt = preSettled ? Messages.get((String)"patient.insurance.pay.presettledrefund") : Messages.get((String)"patient.insurance.pay.paidmorethangapdesc");
            if (this.confirmGapButton != null) {
                this.prompt = this.prompt + "\n" + Messages.get((String)"patient.insurance.pay.confirmdesc");
            }
        } else {
            this.prompt = Messages.get((String)"patient.insurance.pay.fulldesc");
        }
        column.add((Component)LabelFactory.text((String)this.prompt, (boolean)true));
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column}));
        this.enableOK();
        this.resize("GapPaymentPrompt.size");
    }

    public boolean payGap() {
        return this.summary.canPayGap() && this.gapButton.isSelected();
    }

    public boolean confirmGap() {
        return this.confirmGapButton != null && this.confirmGapButton.isSelected();
    }

    public boolean refundGap() {
        return this.refund && this.gapButton.isSelected();
    }

    public boolean payFull() {
        return this.fullButton.isSelected();
    }

    public BigDecimal getPaid() {
        return this.summary.getPaid();
    }

    public BigDecimal getAmountToPay() {
        return this.payGap() ? this.summary.getRemainingGapAmount() : this.summary.getRemainingFullAmount();
    }

    public BigDecimal getAmountToRefund() {
        return this.summary.getRefundAmount();
    }

    protected String getPrompt() {
        return this.prompt;
    }

    protected void setPayGap(boolean payGap) {
        if (this.gapButton.isEnabled()) {
            this.gapButton.setSelected(payGap);
            this.enableOK();
        }
    }

    protected void setPayFull(boolean payFull) {
        if (this.fullButton.isEnabled()) {
            this.fullButton.setSelected(payFull);
            this.enableOK();
        }
    }

    protected void enableOK() {
        this.getButtons().setEnabled("ok", this.confirmGap() || this.payGap() || this.refundGap() || this.payFull());
    }

    protected void onOK() {
        if (this.confirmGap() || this.payGap() || this.refundGap() || this.payFull()) {
            super.onOK();
        }
    }
}

