/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.math.BigDecimal;
import org.openvpms.insurance.internal.claim.GapClaimImpl;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workflow.EditIMObjectTask;
import org.openvpms.web.component.workflow.PrintActTask;
import org.openvpms.web.component.workflow.ReloadTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.BillingCustomerMailContext;
import org.openvpms.web.workspace.patient.insurance.claim.GapPaymentRefundEditTask;
import org.openvpms.web.workspace.workflow.payment.PaymentWorkflow;

class GapClaimPaymentRefundWorkflow
extends PaymentWorkflow {
    private final boolean payment;
    private final BigDecimal paid;
    private final GapClaimImpl claim;

    public GapClaimPaymentRefundWorkflow(BigDecimal amount, boolean payment, BigDecimal paid, GapClaimImpl claim, Context context, HelpContext help) {
        super(amount, false, context, help);
        this.payment = payment;
        this.paid = paid;
        this.claim = claim;
    }

    @Override
    public void start(TaskContext context) {
        super.start(context);
        String archetype = this.payment ? "act.customerAccountPayment" : "act.customerAccountRefund";
        this.addTask((Task)new ReloadTask(archetype));
        PrintActTask print = new PrintActTask(archetype, (MailContext)new BillingCustomerMailContext((Context)this.getContext())){

            protected void notifyPrintCancelled() {
                this.notifySkipped();
            }

            protected void notifyPrintCancelledOnError(Throwable cause) {
                ErrorHelper.show((Throwable)cause);
                this.notifySkipped();
            }
        };
        print.setRequired(false);
        print.setEnableSkip(false);
        this.addTask((Task)print);
    }

    @Override
    protected EditIMObjectTask createPaymentTask(BigDecimal amount) {
        return new GapPaymentRefundEditTask(this.claim, amount, this.payment, this.paid);
    }
}

