/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.util.List;
import nextapp.echo2.app.Component;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.layout.IMObjectTabPane;
import org.openvpms.web.component.im.layout.IMObjectTabPaneModel;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.patient.history.PatientHistoryBrowser;
import org.openvpms.web.workspace.patient.history.PatientHistoryQuery;
import org.openvpms.web.workspace.patient.insurance.claim.AbstractClaimLayoutStrategy;
import org.openvpms.web.workspace.patient.insurance.claim.AttachmentCollectionEditor;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimItemCollectionEditor;

public class ClaimLayoutStrategy
extends AbstractClaimLayoutStrategy {
    private final Party patient;
    private final PropertyEditor insurer;
    private final PropertyEditor policyNumber;
    private final ClaimItemCollectionEditor items;
    private final AttachmentCollectionEditor attachments;
    private IMObjectTabPane pane;

    public ClaimLayoutStrategy(Party patient, PropertyEditor insurer, PropertyEditor policyNumber, ClaimItemCollectionEditor items, AttachmentCollectionEditor attachments, boolean showGapClaim) {
        super(showGapClaim);
        this.insurer = insurer;
        this.policyNumber = policyNumber;
        this.items = items;
        this.attachments = attachments;
        this.patient = patient;
    }

    public void selectAttachments() {
        if (this.pane != null) {
            this.pane.setSelectedIndex(1);
        }
    }

    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        this.addComponent(new ComponentState(this.insurer));
        this.addComponent(new ComponentState(this.policyNumber));
        this.addComponent(new ComponentState((PropertyEditor)this.items));
        this.addComponent(new ComponentState((PropertyEditor)this.attachments));
        return super.apply(object, properties, parent, context);
    }

    @Override
    protected Property getInsurer() {
        return this.insurer.getProperty();
    }

    @Override
    protected Property getPolicyNumber() {
        return this.policyNumber.getProperty();
    }

    protected void doComplexLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
        IMObjectTabPaneModel model = this.doTabLayout(object, properties, container, context, false);
        if (this.patient != null) {
            PatientHistoryQuery query = new PatientHistoryQuery(this.patient, context.getPreferences());
            PatientHistoryBrowser history = new PatientHistoryBrowser(query, context);
            String label = Messages.get((String)"patient.insurance.history");
            label = this.getShortcut(label, model.size() + 1);
            model.addTab(label, history.getComponent());
        }
        this.pane = new IMObjectTabPane(model);
        this.pane.setSelectedIndex(0);
        container.add((Component)this.pane);
    }
}

