/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.patient.insurance.claim.AbstractClaimEditor;
import org.openvpms.web.workspace.patient.insurance.claim.AttachmentCollectionEditor;
import org.openvpms.web.workspace.patient.insurance.claim.ChargeCollectionEditor;
import org.openvpms.web.workspace.patient.insurance.claim.Charges;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimItemLayoutStrategy;

public class ClaimItemEditor
extends AbstractClaimEditor {
    private final ChargeCollectionEditor charges;

    public ClaimItemEditor(Act act, Act parent, Party customer, Party patient, Charges charges, AttachmentCollectionEditor attachments, LayoutContext context) {
        super(act, (IMObject)parent, "total", context);
        this.charges = new ChargeCollectionEditor(this.getCollectionProperty("items"), act, customer, patient, charges, attachments, context);
        this.charges.addModifiableListener(modifiable -> this.onItemsChanged());
        this.addEditor((Editor)this.charges);
        this.addStartEndTimeListeners();
        this.getProperty("status").addModifiableListener(modifiable -> this.onStatusChanged());
    }

    public List<Act> getCharges() {
        return this.charges.getActs();
    }

    public void addCharge(Act charge) {
        if (this.charges.canClaim(charge)) {
            this.charges.add((IMObject)charge);
        }
    }

    protected void onStartTimeChanged() {
        Date now;
        Date start = this.getStartTime();
        if (start != null && start.compareTo(now = new Date()) > 0) {
            this.setStartTime(now);
        }
        super.onStartTimeChanged();
    }

    protected void onEndTimeChanged() {
        Date now;
        Date end = this.getEndTime();
        if (end != null && end.compareTo(now = new Date()) > 0) {
            this.setEndTime(now);
        }
        super.onEndTimeChanged();
    }

    @Override
    protected List<Act> getItemActs() {
        return this.charges.getActs();
    }

    protected ChargeCollectionEditor getChargeCollectionEditor() {
        return this.charges;
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        IMObjectLayoutStrategy strategy = super.createLayoutStrategy();
        strategy.addComponent(new ComponentState((PropertyEditor)this.charges));
        return strategy;
    }

    protected boolean doValidation(Validator validator) {
        boolean valid = super.doValidation(validator);
        if (valid) {
            Property reason = this.getProperty("reason");
            Property description = this.getProperty("description");
            boolean bl = valid = reason.getValue() != null || !StringUtils.isEmpty((CharSequence)description.getString());
            if (!valid) {
                String message = Messages.format((String)"patient.insurance.item.incomplete", (Object[])new Object[]{reason.getDisplayName(), description.getDisplayName()});
                validator.add((Modifiable)this, new ValidatorError(message));
            }
        }
        return valid;
    }

    private void onStatusChanged() {
        IMObjectLayoutStrategy layout = this.getView().getLayout();
        if (layout instanceof ClaimItemLayoutStrategy) {
            boolean euthanased = "EUTHANASED".equals(this.getStatus());
            ((ClaimItemLayoutStrategy)layout).setShowEuthanasiaReason(euthanased);
        }
    }
}

