/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.math.BigDecimal;
import java.util.List;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.act.ActHelper;
import org.openvpms.web.component.im.edit.act.AbstractActEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Property;

public abstract class AbstractClaimEditor
extends AbstractActEditor {
    private final String total;

    public AbstractClaimEditor(Act act, IMObject parent, String total, LayoutContext context) {
        super(act, parent, context);
        this.total = total;
    }

    protected abstract List<Act> getItemActs();

    protected void onItemsChanged() {
        this.calculateAmount();
        this.calculateTax();
    }

    protected void calculateAmount() {
        Property amount = this.getProperty("amount");
        BigDecimal value = ActHelper.sum((Act)this.getObject(), this.getItemActs(), (String)this.total);
        amount.setValue((Object)value);
    }

    protected void calculateTax() {
        Property taxAmount = this.getProperty("tax");
        BigDecimal tax = ActHelper.sum((Act)this.getObject(), this.getItemActs(), (String)"tax");
        taxAmount.setValue((Object)tax);
    }
}

