/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance;

import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.component.im.table.DescriptorTableModel;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class InsuranceTableModel
extends DescriptorTableModel<Act> {
    private final InsuranceRules rules = (InsuranceRules)ServiceHelper.getBean(InsuranceRules.class);
    private static final String[] NAMES = new String[]{"startTime", "insurer", "insurerId", "endTime", "status"};

    public InsuranceTableModel(String[] shortNames, LayoutContext context) {
        super(shortNames, context);
        DescriptorTableColumn endTime;
        DescriptorTableColumn startTime;
        DescriptorTableColumn insurerId = this.getColumn("insurerId");
        if (insurerId != null) {
            insurerId.setHeaderValue((Object)Messages.get((String)"patient.insurance.policyClaimId"));
        }
        if ((startTime = this.getColumn("startTime")) != null) {
            startTime.setHeaderValue((Object)this.getDisplayName("act.patientInsuranceClaim", "startTime"));
        }
        if ((endTime = this.getColumn("endTime")) != null) {
            endTime.setHeaderValue((Object)Messages.get((String)"patient.insurance.expiry"));
        }
    }

    protected String[] getNodeNames() {
        return NAMES;
    }

    protected Object getValue(Act object, DescriptorTableColumn column, int row) {
        Party insurer;
        String name = column.getName();
        Object result = name.equals("insurer") ? ((insurer = this.rules.getInsurer(object)) != null ? insurer.getName() : null) : (name.equals("endTime") && !TypeHelper.isA((IMObject)object, (String)"act.patientInsurancePolicy") ? null : (name.equals("status") && !TypeHelper.isA((IMObject)object, (String)"act.patientInsuranceClaim") ? null : super.getValue((IMObject)object, column, row)));
        return result;
    }
}

