/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.claim.GapClaim;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.system.ServiceHelper;

public class InsuranceActions
extends ActActions<Act> {
    public static final InsuranceActions INSTANCE = new InsuranceActions();

    private InsuranceActions() {
    }

    public boolean canEdit(Act act) {
        boolean result = act.isA("act.patientInsuranceClaim") ? Claim.Status.PENDING.isA(act.getStatus()) : super.canEdit(act);
        return result;
    }

    public boolean canDelete(Act act) {
        boolean result = super.canDelete(act);
        if (result) {
            if (act.isA("act.patientInsurancePolicy")) {
                result = this.getBean((IMObject)act).getValues("claims").isEmpty();
            } else if (act.isA("act.patientInsuranceClaim")) {
                result = Claim.Status.PENDING.isA(act.getStatus());
            }
        }
        return result;
    }

    public boolean canPost(Act act) {
        return act.isA("act.patientInsuranceClaim") && Claim.Status.PENDING.isA(act.getStatus());
    }

    public boolean canSubmit(Act act) {
        String status = act.getStatus();
        return act.isA("act.patientInsuranceClaim") && (Claim.Status.PENDING.isA(status) || Claim.Status.POSTED.isA(status));
    }

    public boolean hasExistingClaims(Act act) {
        if (act.isA("act.patientInsurancePolicy")) {
            IMObjectBean bean = this.getBean((IMObject)act);
            for (Act claim : bean.getSources("claims", Act.class)) {
                String status = claim.getStatus();
                if (Claim.Status.CANCELLED.isA(status) || Claim.Status.DECLINED.isA(claim.getStatus()) || Claim.Status.SETTLED.isA(status)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUnfinalised(Act act) {
        if (act.isA("act.patientInsuranceClaim")) {
            return Claim.Status.PENDING.isA(act.getStatus());
        }
        return super.isUnfinalised(act);
    }

    public boolean warnWhenPrintingUnfinalisedAct() {
        return true;
    }

    public boolean canCancelClaim(Act act) {
        String status = act.getStatus();
        return act.isA("act.patientInsuranceClaim") && (Claim.Status.PENDING.isA(status) || Claim.Status.POSTED.isA(status) || Claim.Status.SUBMITTED.isA(status) || Claim.Status.ACCEPTED.isA(status));
    }

    public boolean canSettleClaim(Act act) {
        String status = act.getStatus();
        return act.isA("act.patientInsuranceClaim") && (Claim.Status.SUBMITTED.isA(status) || Claim.Status.ACCEPTED.isA(status));
    }

    public boolean canPayClaim(Act act) {
        String benefitStatus;
        IMObjectBean bean;
        boolean result = false;
        String status = act.getStatus();
        if (act.isA("act.patientInsuranceClaim") && (Claim.Status.SUBMITTED.isA(status) || Claim.Status.ACCEPTED.isA(status) || Claim.Status.PRE_SETTLED.isA(status)) && (bean = ServiceHelper.getArchetypeService().getBean((IMObject)act)).getBoolean("gapClaim") && (GapClaim.GapStatus.RECEIVED.isA(benefitStatus = act.getStatus2()) || GapClaim.GapStatus.PENDING.isA(benefitStatus) || GapClaim.GapStatus.PAID.isA(benefitStatus))) {
            result = true;
        }
        return result;
    }

    public boolean canDeclineClaim(Act act) {
        String status = act.getStatus();
        return act.isA("act.patientInsuranceClaim") && (Claim.Status.SUBMITTED.isA(status) || Claim.Status.ACCEPTED.isA(status));
    }
}

