/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.info;

import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.alert.MandatoryAlerts;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextHelper;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientByCustomerBrowser;
import org.openvpms.web.component.im.patient.PatientByCustomerQuery;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workspace.BasicCRUDWorkspace;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.CustomerMailContext;
import org.openvpms.web.workspace.patient.CustomerPatientSummary;
import org.openvpms.web.workspace.patient.info.InformationCRUDWindow;
import org.openvpms.web.workspace.patient.summary.CustomerPatientSummaryFactory;

public class InformationWorkspace
extends BasicCRUDWorkspace<Party> {
    private final Preferences preferences;
    private final MandatoryAlerts alerts;

    public InformationWorkspace(Context context, Preferences preferences) {
        super("patient.information", context);
        this.setArchetypes(Party.class, new String[]{"party.patient*"});
        this.setMailContext((MailContext)new CustomerMailContext(context, this.getHelpContext()));
        this.preferences = preferences;
        this.alerts = new MandatoryAlerts(context, this.getHelpContext());
    }

    public void setObject(Party object) {
        super.setObject((IMObject)object);
        ContextHelper.setPatient((Context)this.getContext(), (Party)object, (boolean)false);
        this.firePropertyChange("summary", null, null);
    }

    public void show() {
        super.show();
        this.alerts.show((Party)this.getObject());
    }

    public Component getSummary() {
        CustomerPatientSummaryFactory factory = (CustomerPatientSummaryFactory)ServiceHelper.getBean(CustomerPatientSummaryFactory.class);
        CustomerPatientSummary summary = factory.createCustomerPatientSummary(this.getContext(), this.getHelpContext(), this.preferences);
        return summary.getSummary((Party)this.getObject());
    }

    protected Party getLatest() {
        return (Party)this.getLatest((IMObject)this.getContext().getPatient());
    }

    protected void onSelected(Party object) {
        super.onSelected((IMObject)object);
        this.alerts.show((Party)this.getObject());
    }

    protected void doLayout(Component container) {
        super.doLayout(container);
        Party latest = this.getLatest();
        if (latest != this.getObject()) {
            this.setObject(latest);
        }
    }

    protected CRUDWindow<Party> createCRUDWindow() {
        return new InformationCRUDWindow((Archetypes<Party>)this.getArchetypes(), this.getContext(), this.getHelpContext());
    }

    protected Browser<Party> createSelectBrowser(HelpContext help) {
        return new PatientByCustomerBrowser((PatientByCustomerQuery)this.createSelectQuery(), (LayoutContext)new DefaultLayoutContext(this.getContext(), help));
    }

    protected Query<Party> createSelectQuery() {
        return new PatientByCustomerQuery(this.getArchetypes().getShortNames(), this.getContext());
    }
}

